<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule)
    {
        // Wealth maturity cron (daily at 12 AM)
        $schedule->call(function () {
            app(\App\Http\Controllers\User\UserWealthController::class)
                ->processMatured();
        })->dailyAt('00:00');

        // Daily tasks reset cron (daily at 12 AM)
        $schedule->call(function () {
            app(\App\Http\Controllers\User\UserTaskController::class)
                ->resetDailyTasksCron();
        })->dailyAt('00:00');

        // ✅ Package auto-expiry (runs hourly)
        $schedule->command('packages:expire')->hourly();
    }

    /**
     * Register the commands for the application.
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}

