<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Spin;
use App\Models\Package;

class AdminSpinController extends Controller
{
    // Display all spins
    public function index()
    {
        $spins = Spin::with('package')->get(); // Eager load package
        return view('admin.spins.index', compact('spins'));
    }

    // Show form to create new spin
    public function create()
    {
        $packages = Package::all(); // Show all packages for assigning
        return view('admin.spins.create', compact('packages'));
    }

    // Store new spin
    public function store(Request $request)
    {
        $data = $request->validate([
            'package_id' => 'nullable|exists:packages,id',
            'reward_type' => 'required|string|in:amount,coins',
            'reward_value' => 'required|numeric|min:0',
            'probability' => 'required|numeric|min:0|max:100',
            'status' => 'required|boolean',
        ]);

        Spin::create($data);

        return redirect()->route('admin.spins.index')->with('success', 'Spin created successfully.');
    }

    // Show edit form
    public function edit(Spin $spin)
    {
        $packages = Package::all();
        return view('admin.spins.edit', compact('spin','packages'));
    }

    // Update spin
    public function update(Request $request, Spin $spin)
    {
        $data = $request->validate([
            'package_id' => 'nullable|exists:packages,id',
            'reward_type' => 'required|string|in:amount,coins',
            'reward_value' => 'required|numeric|min:0',
            'probability' => 'required|numeric|min:0|max:100',
            'status' => 'required|boolean',
        ]);

        $spin->update($data);

        return redirect()->route('admin.spins.index')->with('success', 'Spin updated successfully.');
    }

    // Delete spin
    public function destroy(Spin $spin)
    {
        $spin->delete();
        return redirect()->route('admin.spins.index')->with('success', 'Spin deleted successfully.');
    }

    // Lock/Unlock spin
    public function toggleStatus(Spin $spin)
    {
        $spin->status = !$spin->status;
        $spin->save();

        $msg = $spin->status ? 'Spin unlocked successfully.' : 'Spin locked successfully.';
        return redirect()->route('admin.spins.index')->with('success', $msg);
    }
}
