<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Task;
use App\Models\Package;

class AdminTaskController extends Controller
{
    // List all tasks
    public function index()
    {
        $tasks = Task::with('package')->get();
        return view('admin.tasks.index', compact('tasks'));
    }

    // Show form to create a task
    public function create()
    {
        $packages = Package::all();
        return view('admin.tasks.create', compact('packages'));
    }

    // Store new task
    public function store(Request $request)
    {
        $data = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'fake_downloads' => 'required|integer',
            'reward_amount' => 'required|numeric',
            'package_id' => 'required|exists:packages,id',
            'status' => 'required|boolean',
        ]);

        if ($request->hasFile('logo')) {
            $data['logo'] = $request->file('logo')->store('uploads/tasks', 'public');
        }

        Task::create($data);

        return redirect()->route('admin.tasks.index')->with('success','Task created successfully.');
    }

    // Show edit form
    public function edit(Task $task)
    {
        $packages = Package::all();
        return view('admin.tasks.edit', compact('task','packages'));
    }

    // Update task
    public function update(Request $request, Task $task)
    {
        $data = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'fake_downloads' => 'required|integer',
            'reward_amount' => 'required|numeric',
            'package_id' => 'required|exists:packages,id',
            'status' => 'required|boolean',
        ]);

        if ($request->hasFile('logo')) {
            $data['logo'] = $request->file('logo')->store('uploads/tasks', 'public');
        }

        $task->update($data);

        return redirect()->route('admin.tasks.index')->with('success','Task updated successfully.');
    }

    // Delete task
    public function destroy(Task $task)
    {
        $task->delete();
        return redirect()->route('admin.tasks.index')->with('success','Task deleted successfully.');
    }

    // Lock/Unlock task
    public function toggleStatus(Task $task)
    {
        $task->status = !$task->status;
        $task->save();

        return redirect()->route('admin.tasks.index')->with('success','Task status updated successfully.');
    }
}
