<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\Withdrawal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ManageWithdrawController extends Controller
{
    public function pendingWithdraw()
    {
        $title = 'Pending';
  $withdraws = Withdrawal::with(['user', 'payment_method', 'bank'])
            ->where('status', 'pending')
            ->orderByDesc('id')
            ->get();

        return view('admin.pages.withdraw.list', compact('withdraws', 'title'));
    }





    public function rejectedWithdraw()
    {
        $title = 'Rejected';
        $withdraws = Withdrawal::with(['user', 'payment_method'])
            ->where('status', 'rejected')
            ->orderByDesc('id')
            ->get();

        return view('admin.pages.withdraw.list', compact('withdraws', 'title'));
    }

    public function approvedWithdraw()
    {
        $title = 'Approved';
        $withdraws = Withdrawal::with(['user', 'payment_method'])
            ->where('status', 'approved')
            ->orderByDesc('id')
            ->get();

        return view('admin.pages.withdraw.list', compact('withdraws', 'title'));
    }

    public function withdrawStatus(Request $request, $id)
    {
        $withdraw = Withdrawal::with('user')->findOrFail($id);

        // ✅ If Approved
        if ($request->status == 'approved') {
            $withdraw->trx = $request->trx ?? uniqid("TXN"); // fallback trx id
        }

        // ✅ If Rejected → Refund user balance
        if ($request->status == 'rejected') {
            $user = User::find($withdraw->user_id);

            if ($user) {
                $user->balance += $withdraw->amount;
                $user->save();

                // Ledger entry (optional)
                UserLedger::create([
                    'user_id' => $user->id,
                    'type'    => 'credit',
                    'amount'  => $withdraw->amount,
                    'remark'  => 'Withdrawal rejected, amount refunded',
                ]);
            }
        }

        // ✅ Update withdraw status
        $withdraw->status = $request->status;
        $withdraw->admin_feedback = $request->note;
        $withdraw->save();

        return redirect()->back()->with('success', 'Withdraw status updated successfully.');
    }
}
