<?php

namespace App\Http\Controllers\user; // lowercase 'user'

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Package;
use App\Models\Task;
use App\Services\CommissionService;

class CommissionController extends Controller
{
    protected $commissionService;

    public function __construct()
    {
        $this->commissionService = new CommissionService();
    }

    /**
     * Handle Package Buy
     * Expects: user_id, package_id
     */
    public function buyPackage(Request $request)
    {
        $userId = $request->input('user_id');
        $packageId = $request->input('package_id');

        $user = User::find($userId);
        $package = Package::find($packageId);

        if (!$user || !$package) {
            return response()->json([
                'status' => false,
                'message' => 'Invalid user or package'
            ]);
        }

        // Assign package
        $user->package_id = $package->id;
        $user->package_expiry = now()->addDays($package->validity_days);
        $user->save();

        // Distribute commission + credit score
        $this->commissionService->distributeWithCredit(
            $user->id,
            $package->price,
            'package',
            3,
            ['package_id' => $package->id]
        );

        return response()->json([
            'status' => true,
            'message' => 'Package purchased successfully'
        ]);
    }

    /**
     * Handle Task Completion
     * Expects: user_id, task_id
     */
    public function completeTask(Request $request)
    {
        $userId = $request->input('user_id');
        $taskId = $request->input('task_id');

        $user = User::find($userId);
        $task = Task::find($taskId);

        if (!$user || !$task) {
            return response()->json([
                'status' => false,
                'message' => 'Invalid user or task'
            ]);
        }

        // Add task reward to user
        $user->increment('balance', $task->reward_amount);

        // Distribute rebate commission + credit score
        $this->commissionService->distributeWithCredit(
            $user->id,
            $task->reward_amount,
            'task',
            3,
            ['task_id' => $task->id, 'package_id' => $task->package_id]
        );

        return response()->json([
            'status' => true,
            'message' => 'Task completed successfully'
        ]);
    }
}
