<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class CreditScoreController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        // Default credit score if not set
        $creditScore = $user->credit_score ?? 60;

        // Latest 10 credit records
        $creditRecords = $user->creditRecords()
            ->latest()
            ->take(10)
            ->get()
            ->map(function ($rec) {
                return [
                    'title' => $rec->title,
                    'note'  => $rec->note,
                    'delta' => $rec->delta,
                    'date'  => $rec->created_at->format('Y-m-d H:i:s'),
                ];
            });

        return view('user.credit', [
            'creditScore'    => $creditScore,
            'creditRecords'  => $creditRecords,
        ]);
    }
}
