<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Transaction;
use Carbon\Carbon;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        // Work deposit & Effective date
        $workDeposit = $user->balance; // ya kisi aur column se le sakte ho
        $effectiveDate = $user->membership_expires_at ?? null;

        // Earning stats
        $yesterdayEarning = Transaction::where('user_id', $user->id)
            ->whereDate('created_at', Carbon::yesterday())
            ->sum('amount');

        $todayEarning = Transaction::where('user_id', $user->id)
            ->whereDate('created_at', Carbon::today())
            ->sum('amount');

        $thisMonthEarning = Transaction::where('user_id', $user->id)
            ->whereMonth('created_at', Carbon::now()->month)
            ->sum('amount');

        $thisWeekEarning = Transaction::where('user_id', $user->id)
            ->whereBetween('created_at', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()])
            ->sum('amount');

        $totalRevenue = Transaction::where('user_id', $user->id)->sum('amount');

        // Subordinate task commission (refer commissions)
        $subordinateCommission = $user->register_refer_bonus ?? 0;

        return view('user.dashboard', compact(
            'user',
            'workDeposit',
            'effectiveDate',
            'yesterdayEarning',
            'todayEarning',
            'thisMonthEarning',
            'thisWeekEarning',
            'totalRevenue',
            'subordinateCommission'
        ));
    }
}
