<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Membership;
use App\Models\Spin;
use Carbon\Carbon;
use Auth;

class MembershipController extends Controller
{
    // ✅ Show all memberships
    public function index()
    {
        $memberships = Membership::all();
        return view('user.memberships.index', compact('memberships'));
    }

    // ✅ Buy membership
    public function buy($id)
    {
        $user = Auth::user();
        $membership = Membership::findOrFail($id);

        // Agar user already free intern membership le chuka hai
        if ($membership->id == 1 && $user->free_intern_used) {
            return back()->with('error', 'You cannot buy free intern membership again.');
        }

    if (floatval($user->balance) < floatval($membership->price)) {
    return back()->with('error', 'Insufficient balance');
}


        // Balance deduct
        $user->balance -= $membership->price;
        $user->membership_id = $membership->id;
        $user->membership_expires_at = Carbon::now()->addDays($membership->duration_days);

        // Agar free intern membership hai to mark as used
        if ($membership->id == 1) {
            $user->free_intern_used = 1;
        }

        $user->save();

        // Spins assign kare
        if ($membership->spin_limit > 0) {
            for ($i = 0; $i < $membership->spin_limit; $i++) {
                Spin::create([
                    'user_id' => $user->id,
                    'membership_id' => $membership->id,
                    'reward' => 'Spin Reward',
                    'status' => 'unused',
                ]);
            }
        }

        return back()->with('success', 'Membership purchased successfully! Spins credited.');
    }
}
