<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\UserTask;
use App\Models\UserLedger;
use App\Models\Package;
use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use App\Models\BonusLedger;   // Bonus redemptions
use App\Models\UserSpin;      // Spin rewards
use App\Models\Bonus;         // Bonus model (optional, if needed)
use App\Models\Spin;          // Spin model (optional, if needed)

class MineController extends Controller
{
    public function mine()
    {
        $user = auth()->user();

        // Current active package & Invested Amount + Dates
        $package = null;
        $invested_amount = 0;
        $effective_date = null;
        $expiry_date = null;

        if (Schema::hasTable('user_packages')) {
            $userPackage = DB::table('user_packages')
                ->where('user_id', $user->id)
                ->where('status', 'active')
                ->orderByDesc('id')
                ->first();

            if ($userPackage) {
                $package = Package::find($userPackage->package_id);
                $invested_amount = $package->price ?? 0; // ✅ Price column se fetch karna

                // ✅ Effective & Expiry Date
                $effective_date = $userPackage->start_date;
                $expiry_date = $userPackage->end_date;
            }
        }

        // Dates
        $today = Carbon::today();
        $yesterday = Carbon::yesterday();
        $weekStart = Carbon::now()->startOfWeek();
        $monthStart = Carbon::now()->startOfMonth();


        // Base queries
        $tasks = UserTask::where('user_id', $user->id)->where('status', 'completed');
        $bonus = BonusLedger::where('user_id', $user->id);
        $spins = UserSpin::where('user_id', $user->id);
        $referrals = UserLedger::where('user_id', $user->id)
            ->where('reason', 'refer_bonus')
            ->where('status', 'approved');
        $taskRebates = UserLedger::where('user_id', $user->id)
            ->where('reason', 'task_refer_bonus')
            ->where('status', 'approved');


        
        // TODAY
       $today_earnings = (float) (
            (clone $tasks)->whereDate('completed_at', $today)->sum('earned') +
            (clone $bonus)->whereDate('created_at', $today)->sum('amount') +
            (clone $spins)->whereDate('created_at', $today)->sum('reward_value') +
            (clone $referrals)->whereDate('date', $today)->sum('credit') +
            (clone $taskRebates)->whereDate('created_at', $today)->sum('amount')
        );

        // YESTERDAY
        $yesterday_earnings = (float) (
            (clone $tasks)->whereDate('completed_at', $yesterday)->sum('earned') +
            (clone $bonus)->whereDate('created_at', $yesterday)->sum('amount') +
            (clone $spins)->whereDate('created_at', $yesterday)->sum('reward_value') +
            (clone $referrals)->whereDate('date', $yesterday)->sum('credit') +
            (clone $taskRebates)->whereDate('created_at', $yesterday)->sum('amount')
        );  

        // THIS WEEK
        $week_earnings = (float) (
        (clone $tasks)->whereBetween('completed_at', [$weekStart, now()])->sum('earned') +
            (clone $bonus)->whereBetween('created_at', [$weekStart, now()])->sum('amount') +
            (clone $spins)->whereBetween('created_at', [$weekStart, now()])->sum('reward_value') +
            (clone $referrals)->whereBetween('date', [$weekStart, now()])->sum('credit') +
            (clone $taskRebates)->whereBetween('created_at', [$weekStart, now()])->sum('amount')
        );

        // THIS MONTH
        $month_earnings = (float) (
            (clone $tasks)->whereBetween('completed_at', [$monthStart, now()])->sum('earned') +
            (clone $bonus)->whereBetween('created_at', [$monthStart, now()])->sum('amount') +
            (clone $spins)->whereBetween('created_at', [$monthStart, now()])->sum('reward_value') +
            (clone $referrals)->whereBetween('date', [$monthStart, now()])->sum('credit') +
            (clone $taskRebates)->whereBetween('created_at', [$monthStart, now()])->sum('amount')
        );


        // TOTAL
        $total_earnings = (float) (
            $tasks->sum('earned') +
            $bonus->sum('amount') +
            $spins->sum('reward_value') +
            $referrals->sum('credit') +
            $taskRebates->sum('amount')
        );

        // User Ledger approved transactions
        $ledgers = UserLedger::where('user_id', $user->id)
                             ->where('status', 'approved');

        $work_deposit = (float) $ledgers->where('reason', 'user_deposit')->sum('amount');
        $review_funds = (float) UserLedger::where('user_id', $user->id)
                                          ->where('status', 'pending')
                                          ->where('reason', 'user_deposit')
                                          ->sum('amount');

        // --- Referral Commission ---
        $total_referral_commission = UserLedger::where('user_id', $user->id)
            ->where('reason', 'refer_bonus')
            ->where('status', 'approved')
            ->sum('credit');

        $level1_commission = UserLedger::where('user_id', $user->id)
            ->where('reason', 'refer_bonus')
            ->where('status', 'approved')
            ->where('step','first')
            ->sum('credit');

        $level2_commission = UserLedger::where('user_id', $user->id)
            ->where('reason', 'refer_bonus')
            ->where('status', 'approved')
            ->where('step','second')
            ->sum('credit');

        $level3_commission = UserLedger::where('user_id', $user->id)
            ->where('reason', 'refer_bonus')
            ->where('status', 'approved')
            ->where('step','third')
            ->sum('credit');

        // --- Task Rebate Commission ---
        $total_task_rebate = UserLedger::where('user_id', $user->id)
            ->where('reason', 'task_refer_bonus')
            ->where('status', 'approved')
            ->sum('amount');

        $today_task_rebate = UserLedger::where('user_id', $user->id)
            ->where('reason', 'task_refer_bonus')
            ->where('status', 'approved')
            ->whereDate('created_at', Carbon::today())
            ->sum('amount');

        $yesterday_task_rebate = UserLedger::where('user_id', $user->id)
            ->where('reason', 'task_refer_bonus')
            ->where('status', 'approved')
            ->whereDate('created_at', Carbon::yesterday())
            ->sum('amount');

        $week_task_rebate = UserLedger::where('user_id', $user->id)
            ->where('reason', 'task_refer_bonus')
            ->where('status', 'approved')
            ->whereBetween('created_at', [Carbon::now()->startOfWeek(), Carbon::now()])
            ->sum('amount');

        $month_task_rebate = UserLedger::where('user_id', $user->id)
            ->where('reason', 'task_refer_bonus')
            ->where('status', 'approved')
            ->whereBetween('created_at', [Carbon::now()->startOfMonth(), Carbon::now()])
            ->sum('amount');

        // Balance
        $total_balance = $user->balance;
        $available_amount = $user->receive_able_amount;

        return view('app.main.mine.mine', compact(
            'user',
            'package',
            'invested_amount',
            'effective_date',   // 👈 Effective Date
            'expiry_date',      // 👈 Expiry Date
            'today_earnings',
            'yesterday_earnings',
            'week_earnings',
            'month_earnings',
            'total_earnings',
            'work_deposit',
            'review_funds',
            'total_referral_commission',
            'level1_commission',
            'level2_commission',
            'level3_commission',
            'total_task_rebate',
            'today_task_rebate',
            'yesterday_task_rebate',
            'week_task_rebate',
            'month_task_rebate',
            'total_balance',
            'available_amount'
        ));
    }
}
