<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\UserTask;
use App\Models\UserLedger;
use Carbon\Carbon;

class StatementController extends Controller
{
    public function index()
    {
        $user = auth()->user();

        // ✅ My total revenue (from my tasks)
        $totalRevenue = UserTask::where('user_id', $user->id)
                                ->where('status', 'completed')
                                ->sum('earned');

        // ✅ My completed missions (orders)
        $myMission = UserTask::where('user_id', $user->id)
                             ->where('status', 'completed')
                             ->count();

        // ✅ My task income
        $myTaskIncome = $totalRevenue;

        // ✅ Subordinate tasks (direct referrals) - count only
        $subordinateOrders = UserTask::whereHas('user', function($q) use ($user) {
                                        $q->where('ref_by', $user->id);
                                    })
                                    ->where('status', 'completed')
                                    ->count();

        // ✅ Subordinate income (commission) from user_ledgers
        $subordinateIncome = UserLedger::where('user_id', $user->id)
                                    ->where('reason', 'task_refer_bonus')
                                    ->where('status', 'approved')
                                    ->sum('amount');

        // ✅ Last 30 days breakdown
        $last30Days = [];
        for ($i = 0; $i < 30; $i++) {
            $date = Carbon::today()->subDays($i);

            // My tasks
            $tasksQty = UserTask::where('user_id', $user->id)
                                ->where('status', 'completed')
                                ->whereDate('completed_at', $date)
                                ->count();

            $taskIncome = UserTask::where('user_id', $user->id)
                                  ->where('status', 'completed')
                                  ->whereDate('completed_at', $date)
                                  ->sum('earned');

            // Subordinate tasks count
            $subQty = UserTask::whereHas('user', function($q) use ($user) {
                                        $q->where('ref_by', $user->id);
                                    })
                                    ->where('status', 'completed')
                                    ->whereDate('completed_at', $date)
                                    ->count();

            // Subordinate commission (from ledgers)
            $subIncome = UserLedger::where('user_id', $user->id)
                                  ->where('reason', 'task_refer_bonus')
                                  ->where('status', 'approved')
                                  ->whereDate('created_at', $date)
                                  ->sum('amount');

            $last30Days[] = [
                'date' => $date->format('m-d'),
                'quantity' => $tasksQty,
                'task_income' => $taskIncome,
                'subordinate_quantity' => $subQty,
                'subordinate_income' => $subIncome,
            ];
        }

        return view('app.main.statement.daily', compact(
            'totalRevenue',
            'myMission',
            'myTaskIncome',
            'subordinateOrders',
            'subordinateIncome',
            'last30Days'
        ));
    }
}
