<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Task;
use App\Models\UserTask;
use Illuminate\Http\Request;
use Carbon\Carbon;

class TaskController extends Controller
{
    public function index()
    {
        $user = auth()->user();
        $package = $user->package; // Relation user -> package
        $today = Carbon::today()->toDateString();

        // Pehle se assigned tasks check karo
        $existingTasks = UserTask::where('user_id', $user->id)
                                ->whereDate('date', $today)
                                ->count();

        if ($existingTasks == 0 && $package) {
            $tasks = Task::inRandomOrder()
                        ->limit($package->task) // package->task column
                        ->get();

            foreach ($tasks as $task) {
                UserTask::create([
                    'user_id' => $user->id,
                    'task_id' => $task->id,
                    'date' => $today,
                    'status' => 'pending',
                ]);
            }
        }

        // Ab user ke tasks fetch karo
        $userTasks = UserTask::with('task')
                            ->where('user_id', $user->id)
                            ->whereDate('date', $today)
                            ->get();

        return view('user.tasks', [
            'tasks' => $userTasks
        ]);
    }
}
