<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WealthPlan;
use App\Models\UserWealth;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class UserWealthController extends Controller
{
    // Show available plans
    public function index()
    {
        $user = Auth::user();
        $plans = WealthPlan::where('status', 1)->get(); // active plans only
        $investments = UserWealth::with('plan')->where('user_id', $user->id)->get();

        return view('user.wealth.index', compact('plans', 'investments', 'user'));
    }

    // Submit investment
    public function invest(Request $request)
    {
        $request->validate([
            'plan_id' => 'required|exists:wealth_plans,id',
            'amount' => 'required|numeric|min:1'
        ]);

        $user = Auth::user();
        $plan = WealthPlan::findOrFail($request->plan_id);

        if ($request->amount > $user->balance) {
            return back()->with('error', 'Insufficient balance!');
        }

        // Deduct user balance
        $user->balance -= $request->amount;
        $user->save();

        // Calculate start and end dates
        $start = Carbon::now();
        $end = $start->copy()->addDays($plan->days);

        // Create investment record
        UserWealth::create([
            'user_id' => $user->id,
            'wealth_plan_id' => $plan->id,
            'amount' => $request->amount,
            'start_date' => $start->toDateString(),
            'end_date' => $end->toDateString(),
            'status' => 1 // active
        ]);

        return back()->with('success', 'Investment successful!');
    }
}
