<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Membership extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'price',
        'task_limit',
        'per_task_price',
        'duration_days',
        'image',
        'spin_limit',
    ];

    public function users()
    {
        return $this->hasMany(User::class, 'membership_id');
    }

    public function tasks()
    {
        return $this->hasMany(Task::class, 'membership_id');
    }

    public function spins()
    {
        return $this->hasMany(Spin::class, 'membership_id');
    }
}
