<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 
        'price', 
        'per_task_income', 
        'total_income',
        'daily_task_limit',
        'validity_days', 
        'type',        // 'free' or 'paid'
        'logo', 
        'status',      // active/inactive
        'is_free',     // 1 = free, 0 = paid
        'spin_count'   // number of spins to assign on purchase
    ];

    /**
     * Users who bought this package.
     */
    public function userPackages()
    {
        return $this->hasMany(UserPackage::class, 'package_id', 'id');
    }

    /**
     * Tasks included in this package.
     */
    public function tasks()
    {
        return $this->hasMany(Task::class, 'package_id', 'id');
    }

    /**
     * Spins associated with this package.
     */
    public function spins()
    {
        return $this->hasMany(Spin::class, 'package_id', 'id');
    }

    /**
     * Referral credits generated from this package.
     */
    public function referralCredits()
    {
        return $this->hasMany(\DB::getTablePrefix() . 'referral_credits', 'package_id', 'id');
    }

    /**
     * Check if package is free.
     */
    public function isFree()
    {
        return $this->is_free == 1 || $this->type === 'free';
    }

    /**
     * Check if package is active.
     */
    public function isActive()
    {
        return $this->status == 1;
    }
}
