<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Spin extends Model
{
    use HasFactory;

    protected $table = 'spins';

    protected $fillable = [
        'reward_type',   // 'balance', 'bonus', etc.
        'reward_value',  // numeric reward value
        'probability',   // chance of this reward (0-100)
        'status',        // 1 = active, 0 = inactive
        'package_id'     // assign spin to specific package
    ];

    /**
     * Relation: Users who received this spin
     */
    public function userSpins()
    {
        return $this->hasMany(UserSpin::class);
    }

    /**
     * Relation: Package associated with this spin
     */
    public function package()
    {
        return $this->belongsTo(Package::class);
    }

    /**
     * Scope: Only active spins
     */
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }
}
