<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserLedger extends Model
{
    use HasFactory;

    // ✅ Table name (optional agar table ka naam 'user_ledgers' hai to chhod sakte ho)
    protected $table = 'user_ledgers';

    // ✅ Allow mass assignment for these columns
    protected $fillable = [
        'user_id',
        'reason',
        'perticulation',
        'amount',
        'credit',
        'debit',
        'status',
        'date',
    ];

    // ✅ Relationship with User
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
