<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserSpin extends Model
{
    use HasFactory;

    protected $table = 'user_spins';

public $timestamps = false;  // <- disable timestamps


    protected $fillable = [
        'user_id',       // ID of the user who got the spin
        'spin_id',       // ID of the assigned spin
        'package_id',    // ID of the package that triggered the spin
        'reward_value',  // The value user will get from this spin
       'spin_code',
       'created_at' => 'datetime',
    ];

    /**
     * Relation: The spin details
     */
    public function spin()
    {
        return $this->belongsTo(Spin::class);
    }

    /**
     * Relation: The user who got the spin
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Relation: The package that granted this spin
     */
    public function package()
    {
        return $this->belongsTo(Package::class);
    }
}
