<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserWealth extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'wealth_plan_id',
        'amount',
        'start_date',
        'end_date',
        'status',
        'last_earned_at',
    ];

    // ✅ Relations

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function plan()
    {
        return $this->belongsTo(WealthPlan::class, 'wealth_plan_id');
    }
}
