<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {

    public function up()
    {
        Schema::table('user_spins', function (Blueprint $table) {
            $table->unsignedBigInteger('referred_user_id')
                  ->nullable()
                  ->after('user_id');

            // Optional but recommended for safety
            $table->index('referred_user_id');
        });
    }

    public function down()
    {
        Schema::table('user_spins', function (Blueprint $table) {
            $table->dropIndex(['referred_user_id']);
            $table->dropColumn('referred_user_id');
        });
    }
};
