@extends('admin.partials.master')
@section('admin_content')
<div class="container-fluid py-4">
    <h3 class="mb-4">Manage Users Credit Score</h3>

    <!-- Search Form -->
    <form method="GET" action="{{ route('admin.credit.index') }}" class="mb-3 d-flex gap-2">
        <input type="text" name="search" value="{{ request()->search }}" class="form-control" placeholder="Search by username or email">
        <button type="submit" class="btn btn-primary">Search</button>
        <a href="{{ route('admin.credit.index') }}" class="btn btn-secondary">Reset</a>
    </form>

    <div class="table-responsive">
        <table class="table table-striped table-bordered text-center">
            <thead class="thead-dark">
                <tr>
                    <th>ID</th>
                    <th>Username</th>
                    <th>Email</th>
                    <th>Credit Score</th>
                    <th>Balance</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($users as $user)
                <tr>
                    <td>{{ $user->id }}</td>
                    <td>{{ $user->username }}</td>
                    <td>{{ $user->email }}</td>
                    <td>{{ $user->credit_score }}</td>
                    <td>{{ $user->balance }}</td>
                    <td>{{ ucfirst($user->status) }}</td>
                    <td class="d-flex justify-content-center gap-1 flex-wrap">
                        <a href="{{ route('admin.credit.edit', $user->id) }}" class="btn btn-sm btn-info mb-1">Edit</a>

                        <form action="{{ route('admin.credit.reset', $user->id) }}" method="POST" class="mb-1">
                            @csrf
                            <button type="submit" class="btn btn-sm btn-warning" onclick="return confirm('Reset credit score to 0?')">Reset</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-center text-muted">No users found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
