@extends('admin.partials.master')

@section('admin_content')
<style>
    .form-control {
        border-radius: 6px;
        margin-bottom: 15px;
    }
    .btn-submit {
        padding: 10px 20px;
        border-radius: 25px;
    }
</style>

<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header pb-0">
                    <h4 class="card-title">
                        {{ isset($method) ? 'Edit Payment Method' : 'Add New Payment Method' }}
                    </h4>
                </div>

                <div class="card-content">
                    <div class="card-body">
                        <!-- Validation Errors -->
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form action="{{ isset($method) ? route('payment-method.update', $method->id) : route('payment-method.store') }}" method="POST">
                            @csrf
                            @if(isset($method))
                                @method('PUT')
                            @endif

                            <div class="mb-3">
                                <label class="form-label">Channel</label>
                                <input type="text" name="channel" class="form-control" 
                                       value="{{ old('channel', $method->channel ?? '') }}" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Address</label>
                                <input type="text" name="address" class="form-control" 
                                       value="{{ old('address', $method->address ?? '') }}" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Receiver</label>
                                <input type="text" name="receiver" class="form-control" 
                                       value="{{ old('receiver', $method->receiver ?? '') }}" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Minimum Amount</label>
                                <input type="number" step="0.01" name="minimum" class="form-control" 
                                       value="{{ old('minimum', $method->minimum ?? '') }}" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Maximum Amount</label>
                                <input type="number" step="0.01" name="maximum" class="form-control" 
                                       value="{{ old('maximum', $method->maximum ?? '') }}" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select name="status" class="form-control" required>
                                    <option value="active" {{ (old('status', $method->status ?? '') == 'active') ? 'selected' : '' }}>Active</option>
                                    <option value="inactive" {{ (old('status', $method->status ?? '') == 'inactive') ? 'selected' : '' }}>Inactive</option>
                                </select>
                            </div>

                       {{-- ✅ Payment Method Type --}}
<div class="col-sm-12 mt-2">
    <label for="type">Payment Method Type</label>
    <select name="type" id="type" class="form-control" required>
        <option value="">-- Select Type --</option>
        @php
            // get distinct types from table
            $types = \App\Models\PaymentMethod::select('type')->distinct()->pluck('type');
        @endphp

        @foreach($types as $type)
            <option value="{{ $type }}" {{ isset($data) && $data->type == $type ? 'selected' : '' }}>
                {{ ucfirst($type) }}
            </option>
        @endforeach
    </select>
</div>


                            <button type="submit" class="btn btn-primary btn-submit">
                                {{ isset($method) ? 'Update Payment Method' : 'Add Payment Method' }}
                            </button>
                        </form>
                    </div> <!-- /.card-body -->
                </div> <!-- /.card-content -->
            </div> <!-- /.card -->
        </div>
    </div>
</section>
@endsection
