@extends('admin.partials.master')
@section('admin_content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="card-title">All Spins</h4>
                <a href="{{ route('admin.spins.create') }}" class="btn btn-primary">Add New Spin</a>
            </div>

            <div class="card-body table-responsive">
                <table class="table table-striped table-bordered table-hover text-center">
                    <thead class="thead-dark">
                        <tr>
                            <th>ID</th>
                            <th>Package</th>
                            <th>Reward Type</th>
                            <th>Reward Value</th>
                            <th>Probability (%)</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($spins as $spin)
                        <tr>
                            <td>{{ $spin->id }}</td>
                            <td>{{ $spin->package->name ?? 'All Packages' }}</td>
                            <td>{{ ucfirst($spin->reward_type) }}</td>
                            <td>{{ $spin->reward_value }}</td>
                            <td>{{ $spin->probability }}</td>
                            <td>
                                @if($spin->status)
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-danger">Inactive</span>
                                @endif
                            </td>
                            <td class="d-flex justify-content-center gap-1 flex-wrap">
                                <!-- Edit -->
                                <a href="{{ route('admin.spins.edit', $spin->id) }}" class="btn btn-sm btn-info mb-1">Edit</a>

                                <!-- Delete -->
                                <form action="{{ route('admin.spins.destroy', $spin->id) }}" method="POST" class="mb-1" onsubmit="return confirm('Are you sure?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                </form>

                                <!-- Lock/Unlock -->
                                <form action="{{ route('admin.spins.toggleStatus', $spin->id) }}" method="POST" class="mb-1">
                                    @csrf
                                    <button type="submit" class="btn btn-sm @if($spin->status) btn-warning @else btn-success @endif">
                                        @if($spin->status) Lock @else Unlock @endif
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted">No spins available.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
