@extends('admin.partials.master')
@section('admin_content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="card-title">All Tasks</h4>
                <a href="{{ route('admin.tasks.create') }}" class="btn btn-primary">Add New Task</a>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-striped table-bordered table-hover text-center">
                    <thead class="thead-dark">
                        <tr>
                            <th>ID</th>
                            <th>Title</th>
                            <th>Description</th>
                            <th>Logo</th>
                            <th>Fake Downloads</th>
                            <th>Reward</th>
                            <th>Package</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($tasks as $task)
                        <tr>
                            <td>{{ $task->id }}</td>
                            <td>{{ $task->title }}</td>
                            <td>{{ Str::limit($task->description, 50) }}</td>
                            <td>
                                @if($task->logo)
                                    <img src="{{ asset('storage/app/public/uploads/tasks/' . basename($task->logo)) }}" width="50" alt="logo" class="rounded">
                                @else
                                    <span class="text-muted">No Logo</span>
                                @endif
                            </td>
                            <td>{{ $task->fake_downloads }}</td>
                            <td>{{ $task->reward_amount }}</td>
                            <td>{{ $task->package->name ?? 'N/A' }}</td>
                            <td>
                                @if($task->status)
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-danger">Locked</span>
                                @endif
                            </td>
                            <td class="d-flex justify-content-center gap-1 flex-wrap">
                                <!-- Edit -->
                                <a href="{{ route('admin.tasks.edit', $task->id) }}" class="btn btn-sm btn-info mb-1">Edit</a>
                                
                                <!-- Delete -->
                                <form action="{{ route('admin.tasks.destroy', $task->id) }}" method="POST" class="mb-1" onsubmit="return confirm('Are you sure?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                </form>
                                
                                <!-- Lock/Unlock -->
                                <form action="{{ route('admin.tasks.toggleStatus', $task->id) }}" method="POST" class="mb-1">
                                    @csrf
                                    <button type="submit" class="btn btn-sm @if($task->status) btn-warning @else btn-success @endif">
                                        @if($task->status) Lock @else Unlock @endif
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="9" class="text-center text-muted">No tasks available.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
