<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Recharge</title>
  </div>
<!-- Hide the GTranslate UI but keep functionality -->
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>

</div>
<div class="gtranslate_wrapper"></div>
<script>
  window.gtranslateSettings = {
    "default_language": "en",
    "detect_browser_language": true,
    "languages": ["en", "ru", "tr", "hi", "es", "de", "bg", "fr", "it", "zh-TW"],
    "wrapper_selector": ".gtranslate_wrapper",
    "horizontal_position": "right",
    "vertical_position": "top"
  };
</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: url("{{asset ('ch/bg.png')}}") no-repeat center center/cover; }
    .header { background: #4804c6ff; color:#fff; padding:15px; font-size:18px; display:flex; align-items:center; }
    .back-btn { color:#fff; text-decoration:none; margin-right:10px; font-size:20px; }
    .back-btn:hover { color:#ffcdd2; }
    .method-card { background:#fff; padding:15px; margin:10px 0; border-radius:10px; box-shadow:0 2px 6px rgba(0,0,0,0.1); transition:0.3s; }
    .method-card:hover { background:#f3e9ff; cursor:pointer; }
    .method-title { font-weight:600; font-size:16px; }
    .method-desc { font-size:13px; color:#666; }
    .badge-type { font-size:11px; text-transform:uppercase; padding:3px 6px; border-radius:5px; }
    .badge-usdt { background:#28a745; color:#fff; }
    .badge-wallet { background:#007bff; color:#fff; }
  </style>
</head>
<body>

  <div class="header">
    <a href="{{ route('dashboard') }}" class="back-btn">&larr;</a>
    Recharge
  </div>

  <div class="container mt-3">
    <p class="text-muted">
        Available balance {{ number_format(Auth::user()->balance ?? 0,2) }}, please choose a recharge method:
    </p>

    @foreach($methods as $method)
      @php
        // Dynamic link based on type
        $link = $method->type === 'usdt' 
                  ? route('recharge.usdt', $method->id) 
                  : route('recharge.amount', $method->id);
      @endphp

      <a href="{{ $link }}" class="text-decoration-none text-dark">
        <div class="method-card d-flex align-items-center justify-content-between">
          <div class="d-flex align-items-center">
            @if($method->photo)
              <img src="{{ asset($method->photo) }}" width="40" class="me-3 rounded">
            @endif
            <div>
              <div class="method-title">{{ $method->channel }}</div>
              <div class="method-desc">
                Min: {{ number_format($method->minimum,2) }} | Max: {{ number_format($method->maximum,2) }}
              </div>
            </div>
          </div>
          <div>
            <span class="badge-type {{ $method->type === 'usdt' ? 'badge-usdt' : 'badge-wallet' }}">
              {{ $method->type }}
            </span>
          </div>
        </div>
      </a>
    @endforeach

  </div>

</body>
</html>
