<!DOCTYPE html>
<html lang="en">
<head>
    <title>Safe-payment</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
    <style>
        *{margin:0;padding:0;box-sizing:border-box;font-family:Arial,sans-serif;}
        body{
            background: url("{{asset('ch/bg.png')}}") no-repeat center center/cover;
            min-height:100vh;
            display:flex;
            justify-content:center;
            align-items:flex-start;
            padding:20px;
            color:#fff;
        }
        .container{
            width:100%;
            max-width:450px;
            margin-top:30px;
            background: rgba(255,255,255,0.1);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border-radius:15px;
            padding:20px;
            border:1px solid rgba(255,255,255,0.3);
        }
        .header{
            display:flex;
            justify-content:space-between;
            align-items:center;
            margin-bottom:20px;
        }
        .header h4{
            font-size:18px;
            font-weight:bold;
        }
        .header i{
            font-size:20px;
            cursor:pointer;
        }
        .list-group{
            list-style:none;
            padding:0;
        }
        .list-group-item{
            background: rgba(255,255,255,0.15);
            border-radius:30px;
            padding:15px 20px;
            margin-bottom:10px;
            display:flex;
            justify-content:space-between;
            align-items:center;
            cursor:pointer;
            transition:0.3s;
        }
        .list-group-item.active{
            background:#651054;
            color:#fff;
        }
        .list-group-item img{
            width:25px;
            height:25px;
            border-radius:50%;
            margin-right:10px;
            vertical-align:middle;
        }
        .checker{
            width:25px;
            height:25px;
            border-radius:50%;
            display:flex;
            align-items:center;
            justify-content:center;
            font-size:14px;
            transition:0.3s;
        }
        .submit_btn{
            margin-top:20px;
            text-align:center;
        }
        .submit_btn a{
            display:inline-block;
            padding:12px 25px;
            border-radius:30px;
            background:#651054;
            color:#fff;
            text-decoration:none;
            font-weight:bold;
            transition:0.3s;
        }
        .submit_btn a:hover{
            background:#7a1b6f;
        }

        /* Mobile */
        @media(max-width:480px){
            .list-group-item{padding:12px 15px;}
            .submit_btn a{padding:10px 20px;font-size:14px;}
        }
    </style>
</head>
<body>
<div class="container">

    <div class="header">
        <i onclick="window.location.href='{{route('user.deposit')}}'">&#8592;</i>
        <h4>Choose Payment Method</h4>
        <div></div>
    </div>

    <ul class="list-group">
        @foreach(\App\Models\PaymentMethod::where('status', 'active')->get() as $element)
        <li class="list-group-item" onclick="selectMethod(this, '{{$element->id}}')">
            <div style="display:flex;align-items:center;">
                <img src="{{asset($element->photo)}}" alt="">
                <span>{{$element->name}}</span>
            </div>
            <div class="checker"><i class="fa fa-check"></i></div>
        </li>
        @endforeach
    </ul>

    <div class="submit_btn">
        <a href="javascript:void(0)" onclick="goPa()">Confirm</a>
    </div>
    <input type="hidden" name="method" value="">

</div>

@include('alert-message')
<script>
    function selectMethod(el, method_id){
        document.querySelectorAll('.list-group-item').forEach(item=>{
            item.classList.remove('active');
            item.querySelector('.checker').style.background='transparent';
            item.querySelector('.checker').style.color='#fff';
        });

        el.classList.add('active');
        el.querySelector('.checker').style.background='#651054';
        el.querySelector('.checker').style.color='#fff';
        document.querySelector('input[name="method"]').value = method_id;
    }

    function goPa(){
        let method = document.querySelector('input[name="method"]').value;
        if(method != ''){
            window.location.href = '{{url('/payment-confirmation')}}'+'/'+method+'/'+'{{$amount}}';
        }else{
            alert('Please select a payment method');
        }
    }
</script>
</body>
</html>
