<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Confirm Payment</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background:#f9f9f9; }
    .header { background:#4B0082; color:#fff; padding:15px; font-size:18px; }
    .card-box { background:#fff; padding:20px; border-radius:12px; margin-top:20px; box-shadow:0 2px 6px rgba(0,0,0,0.1); }
    .amount { font-size:24px; font-weight:700; color:#4B0082; }
    .copy-btn { font-size:12px; padding:3px 8px; }
    .btn-purple { background:#4B0082; color:#fff; font-weight:600; }
    #timer { font-size:20px; font-weight:bold; text-align:center; margin-top:10px; color:#dc3545; }
  </style>
</head>
<body>

  <div class="header">Payment Amount {{ $amount }}</div>
  <div class="container">
    <div class="card-box">

      <h6>Select Payment Method</h6>
      <div class="d-flex align-items-center mb-3">
        @if($method->logo)
          <img src="{{ asset('storage/'.$method->logo) }}" width="80" class="me-2">
        @endif
        <span>{{ $method->name }}</span>
      </div>

      <div class="alert alert-warning small">
        Payment can only be made once. Multiple payments are not valid!
      </div>

      <h6>1. Transfer <span class="amount">{{ $amount }}</span> to the following account</h6>

      <div class="input-group mb-3">
        <input type="text" class="form-control" value="{{ $method->address }}" readonly>
        <button class="btn btn-outline-secondary copy-btn" onclick="copyText(this)">Copy</button>
      </div>

      @if(!empty($method->bank_name))
      <p><strong>Bank Name:</strong> {{ $method->bank_name }}</p>
      @endif

      @if(!empty($method->account_holder))
      <p><strong>Account Holder:</strong> {{ $method->account_holder }}</p>
      @endif

      <div class="text-center mb-3">
        <p><strong>Scan QR Code</strong></p>
        <img src="https://tse1.mm.bing.net/th/id/OIP.NDKNbQ-I9ApLLVp-E6HSPwHaHa?pid=Api&P=0&h=220" 
             alt="QR Code" width="200" class="border rounded">
      </div>

      <div id="timer">30:00</div>

      <!-- Recharge Form -->
      <form method="POST" action="{{ route('recharge.confirm.submit') }}" class="mt-3">
        @csrf
        <input type="hidden" name="method_id" value="{{ $method->id }}">
        <input type="hidden" name="amount" value="{{ $amount }}">

        <h6>2. Submit Ref No / UTR</h6>
        <input type="text" class="form-control mb-3" name="transaction_id" placeholder="Enter UPI Ref ID" required>

        <button type="submit" class="btn btn-purple w-100">Submit</button>
        <a href="{{ route('recharge') }}" class="btn btn-outline-dark w-100 mt-2">Cancel</a>
      </form>

    </div>
  </div>

  <script>
    function copyText(btn) {
      let input = btn.parentElement.querySelector("input");
      input.select();
      input.setSelectionRange(0, 99999);
      navigator.clipboard.writeText(input.value);
      btn.innerText = "Copied!";
      setTimeout(()=> btn.innerText = "Copy", 2000);
    }

    // Countdown Timer (30 minutes)
    let timerElement = document.getElementById("timer");
    let time = 30 * 60; // 30 minutes in seconds

    function updateTimer() {
      let minutes = Math.floor(time / 60);
      let seconds = time % 60;
      timerElement.textContent = 
        (minutes < 10 ? "0" : "") + minutes + ":" + 
        (seconds < 10 ? "0" : "") + seconds;
      if (time > 0) {
        time--;
      } else {
        clearInterval(timerInterval);
        timerElement.textContent = "Expired!";
      }
    }

    let timerInterval = setInterval(updateTimer, 1000);
    updateTimer();
  </script>
</body>
</html>
