<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<title>{{setting('site_name')}}</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
<style>
    *{margin:0;padding:0;box-sizing:border-box;font-family:Arial,sans-serif;}
    body{
        background: url("{{asset('ch/bg.png')}}") no-repeat center center/cover;
        min-height:100vh;
        color:#fff;
        display:flex;
        justify-content:center;
        padding:20px;
    }
    .container{
        width:100%;
        max-width:500px;
    }
    .header{
        display:flex;
        align-items:center;
        justify-content:space-between;
        margin-bottom:20px;
    }
    .header h4{
        font-size:20px;
        font-weight:bold;
        text-align:center;
        flex:1;
        text-shadow: 0 0 6px #00f0ff,0 0 10px #ff00ff;
    }
    .header i{
        font-size:18px;
        color:#00f0ff;
        text-shadow:0 0 6px #00f0ff,0 0 10px #ff00ff;
        cursor:pointer;
        transition: 0.3s;
    }
    .header i:hover{
        text-shadow:0 0 12px #00f0ff,0 0 18px #ff00ff;
    }
    form{
        background: rgba(255,255,255,0.1);
        backdrop-filter: blur(12px);
        -webkit-backdrop-filter: blur(12px);
        border-radius:20px;
        border:1px solid rgba(255,255,255,0.3);
        padding:20px;
        margin-bottom:20px;
    }
    .input-box{
        margin-bottom:15px;
    }
    .input-box input{
        width:100%;
        padding:12px;
        border-radius:30px;
        border:none;
        outline:none;
        background: rgba(255,255,255,0.05);
        color:#fff;
        font-weight:bold;
        text-shadow: 0 0 4px #00f0ff,0 0 6px #ff00ff;
    }
    .input-box input::placeholder{
        color: rgba(255,255,255,0.7);
    }
    .tipsui{
        display:flex;
        align-items:center;
        background: rgba(255,255,255,0.05);
        border-radius:15px;
        padding:10px;
        margin-bottom:15px;
    }
    .tipsui img{
        width:30px;
        margin-right:10px;
    }
    .welcome{
        font-size:14px;
        margin-bottom:10px;
        text-shadow: 0 0 4px #00f0ff,0 0 6px #ff00ff;
    }
    .btnposit{
        display:block;
        width:100%;
        padding:12px;
        border-radius:30px;
        border:none;
        font-weight:bold;
        cursor:pointer;
        background:#651054;
        color:#fff;
        font-size:16px;
        text-shadow:0 0 6px #ff00ff,0 0 10px #ff99ff;
        transition:0.3s;
    }
    .btnposit:hover{
        background:#7a1b6f;
    }
    /* Binded Bank List */
    .bank-card{
        background: rgba(255,255,255,0.08);
        border:1px solid rgba(255,255,255,0.3);
        border-radius:15px;
        padding:15px;
        margin-bottom:15px;
        position:relative;
    }
    .bank-card h5{
        margin-bottom:5px;
        font-size:16px;
        text-shadow:0 0 4px #00f0ff,0 0 6px #ff00ff;
    }
    .bank-card p{
        font-size:14px;
        margin-bottom:4px;
    }
    .delete-btn{
        position:absolute;
        top:10px;
        right:10px;
        background:#ff004c;
        border:none;
        color:#fff;
        padding:6px 12px;
        border-radius:20px;
        cursor:pointer;
        font-size:12px;
        font-weight:bold;
        transition:0.3s;
    }
    .delete-btn:hover{
        background:#cc003a;
    }
</style>

</head>
<body>
<div class="container">
    <!-- Header with Back Button -->
    <div class="header">
        <div onclick="window.history.back();">
            <i class="fa fa-chevron-left"></i>
        </div>
        <h4>Bank Account</h4>
        <div style="width:18px;"></div> <!-- Empty div for alignment -->
    </div>

    <!-- Bank Account Form -->
    <form action="{{route('setup.gateway')}}" method="post">
        @csrf
        <div class="input-box">
            <input type="text" name="bank_name" placeholder="Enter Bank Name eg mpesa, airtel, MTN" required>
        </div>

        <div class="input-box">
            <input type="tel" name="account_number" placeholder="Enter Account Number" required>
        </div>

        

        <div class="input-box">
            <input type="text" name="account_name" placeholder="Enter Account Holder Name" required>
        </div>

        <div class="input-box">
            <input type="password" name="password" placeholder="Enter Fund Password" required>
        </div>

        <button type="submit" class="btnposit">Add Bank</button>
    </form>

    <!-- Already Binded Bank Accounts -->
    <h4 style="margin-bottom:10px;">My Bank Accounts</h4>
  @foreach($banks as $bank)
    <div class="bank-card">
        <h5>{{$bank->bank_name}}</h5>
        <p><b>Account No:</b> {{$bank->account_number}}</p>
        <p><b>Holder:</b> {{$bank->account_name}}</p>

        <form action="{{route('bank.delete',$bank->id)}}" method="post" onsubmit="return confirm('Are you sure you want to delete this bank?');">
            @csrf
            @method('DELETE')
            <button type="submit" class="delete-btn">Delete</button>
        </form>
    </div>
@endforeach
<body class="">
<div id="app" data-v-app="">
    @include('alert-message')
    <div>
        <form action="{{route('user.change.password.confirmation')}}" method="post">
            @csrf
            <div class="bankpage" data-v-45df3e73="">
                <div class="van-nav-bar van-hairline--bottom transparent" data-v-45df3e73="">
                    <div class="van-nav-bar__content">
                        <div class="van-nav-bar__left van-haptics-feedback" onclick="window.location.href='{{route('mine')}}'"><i
                                class="van-badge__wrapper van-icon van-icon-arrow-left van-nav-bar__arrow"><!----><!---->
                                <!----></i><!----></div>
                        <div class="van-nav-bar__title van-ellipsis">Password</div><!----></div>
                </div>
                <section class="section-box" data-v-45df3e73="">
                    <div class="bankunt" data-v-45df3e73=""><img class="imgl"
                                                                 
                                                                 alt="" data-v-45df3e73="">
                        <p data-v-45df3e73="">Change password</p><img class="imgui"
                                                                      src="{{asset('public')}}/IndustrialRobots/dist/img/1.2a3cfcca.png" alt=""
                                                                      data-v-45df3e73=""></div>
                    <p class="accounti" data-v-45df3e73="">Old password</p>
                    <div class="van-cell van-field input-box" data-v-45df3e73=""><!----><!---->
                        <div class="van-cell__value van-field__value">
                            <div class="van-field__body"><input type="password" id="van-field-15-input"
                                                                name="old_password"
                                                                class="van-field__control"
                                                                placeholder="Please enter old password"><!----><!---->
                                <!----></div><!----><!----></div><!----><!----></div>
                    <p class="accounti" data-v-45df3e73="">New password</p>
                    <div class="van-cell van-field input-box" data-v-45df3e73=""><!----><!---->
                        <div class="van-cell__value van-field__value">
                            <div class="van-field__body"><input type="password" id="van-field-16-input"
                                                                class="van-field__control"
                                                                name="new_password"
                                                                placeholder="Please enter new password"><!----><!---->
                                <!----></div><!----><!----></div><!----><!----></div>
                    <p class="accounti" data-v-45df3e73="">Confirm password</p>
                    <div class="van-cell van-field input-box" data-v-45df3e73=""><!----><!---->
                        <div class="van-cell__value van-field__value">
                            <div class="van-field__body"><input type="password" id="van-field-17-input"
                                                                class="van-field__control"
                                                                name="confirm_password"
                                                                placeholder="Enter new password again"><!----><!----><!---->
                            </div><!----><!----></div><!----><!----></div>
                    <div class="tipsui" data-v-45df3e73=""><img
                            src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAAAXNSR0IArs4c6QAABDlJREFUWEfVmX2IVFUUwH9nVslA19IEIyKhqCAqYd/M1irZB/0lUfRhREVCYaXt+kdQa4JYUFtBUJrbB4gIRZQSRcxfYVLQ2s68DVGCCgpDosLNVTfIxd135N6585qPN/vemxllev++c879vXPv+bjnCU08upUMq/EQbkfpAa4BLkVYYM0pk8AfwE8IYyhfkceXrQRpl5M0CnqQy5hmA8ojwOVpdIGjCB8whx2ynN+T6iYC1FEW08VLKI8DF0QYV4QTwCn3rhvlIiDK/hTCTmbYIr38HQcaC6gFHkR4G7ikwpgCBxC+IOAbMvwgHicrF1OfhQRcR4ZbUO4Cbq4BHkd5RnJ8PBtkQ0DdzxwWsA3lqdCwMIWym4A3pJef476+CniUq8nwLMJjaLgLxvPvMsmA3MZ0lL1IQB3hQuayB1hdobSPgPVpwWoX1RLoMHBHxbs8Z3hA+vi3Vr4O0HpuPp+FcMoMGTbTw+simK1t+VHjtzGeI+BlhC5nMM8/3FPryXpAn2GUp53SaZSHJcenLVNFRVaBexE+BObZ18I74rG+UrQK0AXER1bUeA7WJIXTAqsQrkLJS44/k36QGkj4xHlSUR6qDJwQ0KaSDD+G0SoMisdrSRbSAhsR3nSyf6EsTwXp8zzKq05/nIBryynoP0CfHWjo3n143Jn0zKnPQZQbKz7mCcmyM8nHGRl7Jn2+DANHGBaPDaVdNwKmQpzhF5uETSqZ4YY00apF9gL3hUDKrZLj66SAlsFEdxeHXAqaYi5XmopTAiwwhDDoDL4vWZ5MZbzAUpvMzRkM2CU53kqjX5bVIu8B61zADInHC+IK/xFXW9Xtf6ok3AxMlI7LkSYOjOOOkmeZaJEcMOoURiTLinYt2IwdLfIt0Od0e0V9BlGGnFs3iRdGU6x99VmJML9KcJpf05zf2kXqeLRoS9r9VlBZITlGYslK53YLwot1siZ/drFSevguiZ06wAJ9iPWiefaaLT4EXG/xhItru5JGi6jPLpS1Dd73S9Z2QKkf2wUpE+4cHjaAx2xyViYkx6KkFvV7ljDNABm6nfdNHlzljsqAeGxPaivCi8eNs4BxcwZNvTX57zfxWNa0UZ9+lG1tAfQ5gnKFycn/A8DyFgsT4iXf4ojoa6cHj6PlLW4ySM4VYFSQNJVmzhlgXZppIVFXQmqbgiQqUbel1LUNsK7UlaYELTcL7QCMbBZshfN5BWWT27JE7ZaOcRMB2xEWukRtLupLnI1j7iIPAadQ+qWXA3E5NrLdsoBNNKxVNTxuZWGPeKyZTWzWhtV5MVXLr0XuBnaD82DDos0kwqOS5fOGInEtvwVs4dIU58C495rk0mQhS3OYpq6dcRANvZf02lk2oJ18cbde7PTRh4Xs5OFRuNWdPH6rqrGdOsCsgkwyAlZOkHEj4IBu5DyNgKtAO3WIXtf7ncffEGcBV60t4f/CB9oAAAAASUVORK5CYII="
                            alt="" data-v-45df3e73="">
                        <p data-v-45df3e73="">Kind reminder</p></div>
                    <p class="welcome" data-v-45df3e73="">Do not share your password, keep it confidential to keep your
                        account secure.</p>
                    <button class="btnposit" data-v-45df3e73="" type="submit">Confirm Now</button>
                </section>
            </div>
        </form>

    </div><!----></div>
</body>
<!-- Hide the GTranslate UI but keep functionality -->
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>

</div>
<div class="gtranslate_wrapper"></div>
<script>
  window.gtranslateSettings = {
    "default_language": "en",
    "detect_browser_language": true,
    "languages": ["en", "ru", "tr", "hi", "es", "de", "bg", "fr", "it", "zh-TW"],
    "wrapper_selector": ".gtranslate_wrapper",
    "horizontal_position": "right",
    "vertical_position": "top"
  };
</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>

</div>
@include('alert-message')
</body>
</html>
