<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Invite Friends</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: Arial, sans-serif;
    }

    body {
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: flex-start;
      background: url("{{ asset('ch/bg.png') }}") no-repeat center center/cover;
      padding: 20px;
      color: #fff;
    }

    .container {
      width: 100%;
      max-width: 400px;
      text-align: center;
      position: relative;
      margin-top: 40px;
    }

    .back-arrow {
      position: absolute;
      top: 15px;
      left: 15px;
      font-size: 24px;
      color: #fff;
      cursor: pointer;
    }

    h2 {
      margin-bottom: 20px;
      font-weight: 500;
      color: #ffcc00;
    }

    .referral-box {
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      padding: 20px;
      border-radius: 12px;
      border: 1px solid rgba(255, 255, 255, 0.3);
      margin-bottom: 20px;
      word-wrap: break-word;
    }

    .referral-box span {
      display: block;
      font-weight: bold;
      color: #ffdd57;
      margin-bottom: 10px;
    }

    .qr-code {
      margin: 20px auto;
      width: 180px;
      height: 180px;
      background: #fff;
      padding: 10px;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.3);
    }

    .btn {
      width: 100%;
      padding: 14px;
      border: none;
      border-radius: 30px;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
      margin: 10px 0;
      transition: 0.3s ease;
    }

    .btn-copy {
      background: #651054;
      color: #fff;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }

    .btn-copy:hover {
      background: #7a1b6f;
    }

    .info-box {
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      padding: 20px;
      border-radius: 12px;
      text-align: center;
      border: 1px solid rgba(255, 255, 255, 0.3);
      font-size: 14px;
      line-height: 1.6;
    }

    @media (max-width: 480px) {
      .btn {
        font-size: 14px;
        padding: 12px;
      }
      h2 {
        font-size: 18px;
      }
      .qr-code {
        width: 140px;
        height: 140px;
      }
    }
  </style>
</head>
<body>
 <div class="container">
  <div class="back-arrow" onclick="window.location.href='{{ route('dashboard') }}'">&#8592;</div>

  <h2>Invite Your Friends</h2>

  <div class="referral-box">
    <span>Your Referral Link:</span>
    <a href="{{ url('/register') . '?ref=' . auth()->user()->ref_id }}" class="no-underline">
        {{ url('/register') . '?ref=' . auth()->user()->ref_id }}
    </a>
</div>

<style>
.referral-box a.no-underline {
    text-decoration: none; /* Removes underline */
    color: inherit; /* Optional: keeps the text color same as surrounding text */
}
</style>



  <!-- QR Code Placeholder -->
  <div class="qr-code" id="qrcode" style="background: #fff;"></div>

  <button class="btn btn-copy"
    onclick="copyLink('{{ url('/register') . '?ref=' . auth()->user()->ref_id }}')">
    Copy Referral Link
</button>



  <div class="info-box" style="background:#f8f8f8; color:#333; border:1px solid #ccc;">
    Invite friends to join BBDO-task Earn App and earn commissions automatically. Share your referral link or QR code and start earning rewards!
  </div>
</div>
</div>
<!-- Hide the GTranslate UI but keep functionality -->
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>

</div>
<div class="gtranslate_wrapper"></div>
<script>
  window.gtranslateSettings = {
    "default_language": "en",
    "detect_browser_language": true,
    "languages": ["en", "ru", "tr", "hi", "es", "de", "bg", "fr", "it", "zh-TW"],
    "wrapper_selector": ".gtranslate_wrapper",
    "horizontal_position": "right",
    "vertical_position": "top"
  };
</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
  @include('alert-message')

  <!-- QRCode.js Library -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
  <script>
  const referralLink = '{{ url('/register') . '?ref=' . auth()->user()->ref_id }}';

  const qrBox = document.getElementById("qrcode");
  const size = qrBox.clientWidth - 20; // fits inside padding

  new QRCode(qrBox, {
    text: referralLink,
    width: size,
    height: size,
    colorDark: "#651054",
    colorLight: "#ffffff",
    correctLevel: QRCode.CorrectLevel.H
  });

  function copyLink(text) {
    const input = document.createElement("input");
    input.value = text;
    input.style.opacity = 0;
    document.body.appendChild(input);
    input.select();
    input.setSelectionRange(0, input.value.length);
    document.execCommand("copy");
    input.remove();
    message('Copied successfully!');
  }
</script>

</body>
</html>
