<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Credit Score</title>
<style>
body { margin:0; font-family:sans-serif; background:#f3e5f5; }
header { background:#9C27B0; color:white; padding:20px; text-align:center; font-size:24px; font-weight:bold; }
.container { padding:20px; }
.card { background:white; padding:15px; border-radius:10px; box-shadow:0 3px 6px rgba(0,0,0,0.1); margin-bottom:15px; }
.card h3 { margin:0 0 10px 0; font-size:18px; }
.card p { margin:0; font-size:16px; }
.score-high { color:green; font-weight:bold; }
.score-low { color:red; font-weight:bold; }
</style>
</head>
<body>
<header>Credit Scores</header>

<div class="container">
    @foreach($credits as $credit)
    <div class="card">
        <h3>{{ $credit->title }}</h3>
        <p>Score: <span class="{{ $credit->score > 50 ? 'score-high' : 'score-low' }}">{{ $credit->score }}</span></p>
        <p>{{ $credit->description }}</p>
    </div>
    @endforeach
</div>
</body>
</html>
