<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Memberships</title>
<style>
body { margin:0; font-family:sans-serif; background:#fff3e0; }
header { background:#FF9800; color:white; padding:20px; text-align:center; font-size:24px; font-weight:bold; }
.container { display:grid; grid-template-columns:repeat(auto-fit,minmax(250px,1fr)); gap:20px; padding:20px; }
.card { background:white; padding:15px; border-radius:10px; box-shadow:0 3px 6px rgba(0,0,0,0.1); text-align:center; }
.card img { width:100%; height:150px; object-fit:cover; border-radius:8px; margin-bottom:10px; }
.card h3 { margin:5px 0; font-size:18px; }
.card p { margin:5px 0; font-size:14px; }
.card .active { background:green; color:white; padding:5px 10px; border-radius:5px; display:inline-block; margin-top:5px; }
.card .buy { background:#FF9800; color:white; padding:5px 10px; border-radius:5px; display:inline-block; margin-top:5px; text-decoration:none; }
</style>
</head>
<body>
<header>My Memberships</header>

<div class="container">
    @foreach($memberships as $membership)
    <div class="card">
        <img src="{{ asset($membership->photo) }}" alt="{{ $membership->name }}">
        <h3>{{ $membership->name }}</h3>
        <p>Price: ${{ $membership->price }}</p>
        <p>Per Task Price: ${{ $membership->task_price }}</p>
        @if($membership->userHas)
            <span class="active">Active</span>
        @else
            <a href="#" class="buy">Buy</a>
        @endif
    </div>
    @endforeach
</div>
</body>
</html>
