<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Memberships</title>
<style>
body {
    font-family: Arial, sans-serif;
    background: #f0f2f5;
    margin: 0;
    padding: 0;
}
.container {
    width: 90%;
    max-width: 1000px;
    margin: 20px auto;
}
h1 {
    text-align: center;
    margin-bottom: 20px;
}
.membership-card {
    background: #fff;
    border-radius: 10px;
    padding: 20px;
    margin-bottom: 15px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    display: flex;
    gap: 20px;
    align-items: center;
}
.membership-photo {
    width: 100px;
    height: 100px;
    border-radius: 10px;
    object-fit: cover;
    border: 1px solid #ddd;
}
.membership-info {
    flex: 1;
}
.membership-info h2 {
    margin: 0 0 10px;
}
.membership-info p {
    margin: 4px 0;
    font-size: 14px;
    color: #555;
}
.status-active { color: green; font-weight: bold; }
.status-inactive { color: red; font-weight: bold; }
.buy-btn {
    padding: 10px 20px;
    border: none;
    background: #007bff;
    color: #fff;
    border-radius: 5px;
    cursor: pointer;
}
.buy-btn:disabled {
    background: #ccc;
    cursor: not-allowed;
}
</style>
</head>
<body>

<div class="container">
    <h1>Available Memberships</h1>

    @foreach($memberships as $membership)
    <div class="membership-card">
        <img src="{{ asset('uploads/'.$membership->photo) }}" alt="Photo" class="membership-photo">
        <div class="membership-info">
            <h2>{{ $membership->name }}</h2>
            <p>Price: ${{ $membership->price }}</p>
            <p>Per Task Price: ${{ $membership->per_task_price }}</p>
            <p>Daily Tasks: {{ $membership->daily_tasks }}</p>
            <p>Spin Limit: {{ $membership->spin_limit }}</p>
            <p>Duration: {{ $membership->duration_days }} days</p>
            <p>Status: <span class="status-{{ $membership->status }}">{{ $membership->status }}</span></p>
        </div>
        <div>
            @if(auth()->user()->membership_id == $membership->id)
                <button class="buy-btn" disabled>Already Purchased</button>
            @else
                <form method="POST" action="{{ route('user.membership.buy', $membership->id) }}">
                    @csrf
                    <button class="buy-btn">Buy</button>
                </form>
            @endif
        </div>
    </div>
    @endforeach

</div>
@include('alert-message')
</body>
</html>
