<!DOCTYPE html>
<html lang="en">
<head>
    @include('app.layout.css')
</head>

<body>
@include('app.layout.loading')
<link rel="stylesheet" href="{{asset('public/spin/spain.css')}}">

<style>
    #spin-container {
        text-align: center;
        background: linear-gradient(to bottom, 
            #8b159a 0%,   /* Dark Purple top */
            #ffffff 50%, /* White middle */
            #8b159a 100% /* Dark Purple bottom */
        );
        padding: 20px;
       
    }

    #spinner {
        display: flex;
        justify-content: center;
        align-items: center;
        position: relative;
    }

    #spinerImage {
        width: 320px;
        height: 320px;
    }

    #spin_round {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        cursor: pointer;
        width: 100px;
    }
</style>


<div class="spin_banner"
     style="background: linear-gradient(rgba(139, 21, 154, .4), rgba(139, 21, 154, 1)), url('{{asset('public/spin/image')}}/s_banner.jpg') no-repeat;
      background-size: cover">
    <div class="spin_back" onclick="window.location.href='{{route('dashboard')}}'">
        <i class="fa fa-chevron-left"></i>
    </div>
    <div>
        <h1 class="d_draw">Daily draw</h1>
        <h1 class="l_wheel">Lucky wheel</h1>
    </div>
</div>

<div id="spin-container">
    <div class="congregate">
        <p id="congratulations_user"></p>
    </div>

    <div id="spinner" class="spin-to-win">
        <div>
            <img id="spinerImage" src="{{asset('122.png')}}" />
        </div>
        <div id="spin">
            <!-- Spin button direct play karega -->
            <img id="spin_round" onclick="spinToWin()" src="{{asset('public/spin/image')}}/draw-now.png">
        </div>
    </div>

  
    <div class="rules">
        <img class="ribbon" src="{{asset('public/spin/image')}}/ribbon3.png">
        <p class="activity_rules">Activity Rules</p>
    </div>

    <div class="activity_notice">
        <p>1. The spin lucky draw is only for paids user.</p>
        <p>2. The spins is valid for 1 time.</p>
    </div>

    <div class="rules">
        <img class="ribbon" src="{{asset('public/spin/image')}}/ribbon3.png">
        <p class="activity_rules">Leader Board</p>
    </div>
</div>

<meta name="csrf-token" content="{{ csrf_token() }}" />
@include('alert-message')

@include('app.layout.js')

<script>
    // Fake congratulation text
    setInterval(function (){
        function randomIntFromInterval(min, max) {
            return Math.floor(Math.random() * (max - min + 1) + min)
        }
        document.getElementById('congratulations_user').innerHTML =
            `Congratulations user${randomIntFromInterval(1,99)} ${randomIntFromInterval(100,999)}*****${randomIntFromInterval(100,999)} for get .${randomIntFromInterval(10,290)}.00`
    }, 2000)

    // Spin Animation + Backend Call
    var spinerImage = document.getElementById('spinerImage');
    var spinArrow = document.getElementById('spin_round');

    function spinToWin() {
        // random rotation for animation
        let value = Math.ceil(Math.random() * 4000);
        spinerImage.style.transition = '5s';
        spinerImage.style.transform = 'rotate('+ value +'deg)';

        // Backend call
        fetch("{{ route('user.spin.play') }}", {
            method: "POST",
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(res => res.json())
        .then(data => {
            setTimeout(function (){
                message(data.message);
            }, 5000);
        })
        .catch(() => {
            message("⚠️Some mistake again try");
        });
    }
</script>
<div class="spin-history" style="margin:20px;">
    <h3 style="text-align:center;color:#fff;margin-bottom:15px;">
        Your Spin History
    </h3>

    <div style="display:flex;flex-direction:column;gap:15px;" id="spinHistoryWrapper">
        @forelse($spinHistory as $history)
            <div style="
                display:flex;
                justify-content:space-between;
                background:rgba(255,255,255,0.15);
                backdrop-filter:blur(10px);
                border-radius:15px;
                padding:15px;
                align-items:center;
                box-shadow:0 8px 32px rgba(0,0,0,0.2);
                border:1px solid rgba(255,255,255,0.2);
            ">
                <div>
                    <div style="font-weight:bold;color:#ffdd57;">
                        Spin Code: {{ $history->spin_code }}
                    </div>
                    <div style="color:#fff;margin-top:5px;">
                        {{ $history->reward_value }}
                        
                    </div>
                </div>

                <div style="text-align:right;">
                    <div style="font-size:14px;color:#ddd;">
                        {{ \Carbon\Carbon::parse($history->created_at)->format('d-m-Y H:i') }}

                    </div>
                    <div style="color:#4caf50;margin-top:5px;">
                        Completed
                    </div>
                </div>
            </div>
        @empty
            <div style="text-align:center;color:#fff;">
                No spins yet.
            </div>
        @endforelse
    </div>
</div>

</body>
</html> 