<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>My Team</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">

    <h1 class="text-2xl font-bold text-center mb-6">My 3-Level Team</h1>

    <!-- User Info -->
    <div class="bg-white p-4 rounded-lg shadow mb-6">
        <h2 class="text-lg font-semibold mb-2">Your Profile</h2>
        <p><strong>Username:</strong> {{ $user->username }}</p>
        <p><strong>Email:</strong> {{ $user->email }}</p>
        <p><strong>Phone:</strong> {{ $user->phone }}</p>
        <p><strong>Balance:</strong> {{ $user->balance }}</p>
        <p><strong>Credit Score:</strong> {{ $user->credit_score }}</p>
    </div>

    <!-- Level 1 -->
    <div class="mb-6">
        <h2 class="text-xl font-semibold mb-3">Level 1 (Direct Referrals)</h2>
        <table class="w-full border">
            <thead class="bg-gray-200">
                <tr>
                    <th class="p-2 border">Username</th>
                    <th class="p-2 border">Email</th>
                    <th class="p-2 border">Phone</th>
                    <th class="p-2 border">Balance</th>
                    <th class="p-2 border">Credit Score</th>
                </tr>
            </thead>
            <tbody>
                @forelse($level1 as $u)
                <tr class="text-center">
                    <td class="border p-2">{{ $u->username }}</td>
                    <td class="border p-2">{{ $u->email }}</td>
                    <td class="border p-2">{{ $u->phone }}</td>
                    <td class="border p-2">{{ $u->balance }}</td>
                    <td class="border p-2">{{ $u->credit_score }}</td>
                </tr>
                @empty
                <tr><td colspan="5" class="p-2 text-center">No direct referrals</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Level 2 -->
    <div class="mb-6">
        <h2 class="text-xl font-semibold mb-3">Level 2</h2>
        <table class="w-full border">
            <thead class="bg-gray-200">
                <tr>
                    <th class="p-2 border">Username</th>
                    <th class="p-2 border">Email</th>
                    <th class="p-2 border">Phone</th>
                    <th class="p-2 border">Balance</th>
                    <th class="p-2 border">Credit Score</th>
                </tr>
            </thead>
            <tbody>
                @forelse($level2 as $u)
                <tr class="text-center">
                    <td class="border p-2">{{ $u->username }}</td>
                    <td class="border p-2">{{ $u->email }}</td>
                    <td class="border p-2">{{ $u->phone }}</td>
                    <td class="border p-2">{{ $u->balance }}</td>
                    <td class="border p-2">{{ $u->credit_score }}</td>
                </tr>
                @empty
                <tr><td colspan="5" class="p-2 text-center">No level 2 members</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Level 3 -->
    <div>
        <h2 class="text-xl font-semibold mb-3">Level 3</h2>
        <table class="w-full border">
            <thead class="bg-gray-200">
                <tr>
                    <th class="p-2 border">Username</th>
                    <th class="p-2 border">Email</th>
                    <th class="p-2 border">Phone</th>
                    <th class="p-2 border">Balance</th>
                    <th class="p-2 border">Credit Score</th>
                </tr>
            </thead>
            <tbody>
                @forelse($level3 as $u)
                <tr class="text-center">
                    <td class="border p-2">{{ $u->username }}</td>
                    <td class="border p-2">{{ $u->email }}</td>
                    <td class="border p-2">{{ $u->phone }}</td>
                    <td class="border p-2">{{ $u->balance }}</td>
                    <td class="border p-2">{{ $u->credit_score }}</td>
                </tr>
                @empty
                <tr><td colspan="5" class="p-2 text-center">No level 3 members</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>

</body>
</html>
