<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Wallet</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@3.3.2/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-900 text-white font-sans">

<div class="max-w-md mx-auto p-5">
    <h1 class="text-2xl font-bold text-center mb-5">My Wallet</h1>

    <!-- User Info -->
    <div class="bg-gray-800 rounded-lg p-4 mb-5">
        <div class="text-gray-400 text-sm">User:</div>
        <div class="text-white text-lg font-semibold">{{ $user->username }}</div>
        <div class="text-gray-400 text-sm mt-1">ID: {{ $user->id }}</div>
    </div>

    <!-- Total Balance -->
    <div class="bg-purple-700 rounded-lg p-4 mb-5 text-center">
        <div class="text-gray-200">Total Balance (PKR)</div>
        <div class="text-3xl font-bold mt-2">{{ number_format($totalBalance, 2) }}</div>
    </div>

    <!-- Work Deposit -->
    @if($workDeposit)
    <div class="bg-gray-800 rounded-lg p-4 mb-5">
        <div class="flex justify-between text-gray-400 text-sm mb-1">
            <span>Work deposit</span>
            <span>{{ number_format($workDeposit->final_amount, 2) }}</span>
        </div>
        <div class="flex justify-between text-gray-400 text-sm">
            <span>Effective date</span>
            <span>{{ date('Y-m-d', strtotime($workDeposit->created_at)) }}</span>
        </div>
    </div>
    @endif

    <!-- Earnings -->
    <div class="bg-gray-800 rounded-lg p-4 mb-5">
        <div class="flex justify-between text-gray-400 text-sm mb-1">
            <span>Yesterday's earnings</span>
            <span>0.00</span>
        </div>
        <div class="flex justify-between text-gray-400 text-sm mb-1">
            <span>Today's earnings</span>
            <span>{{ number_format($todayEarnings, 2) }}</span>
        </div>
        <div class="flex justify-between text-gray-400 text-sm mb-1">
            <span>This week's earnings</span>
            <span>{{ number_format($weekEarnings, 2) }}</span>
        </div>
        <div class="flex justify-between text-gray-400 text-sm mb-1">
            <span>This month's earnings</span>
            <span>{{ number_format($monthEarnings, 2) }}</span>
        </div>
        <div class="flex justify-between text-gray-400 text-sm mb-1">
            <span>Total revenue</span>
            <span>{{ number_format($totalBalance, 2) }}</span>
        </div>
        <div class="flex justify-between text-gray-400 text-sm mb-1">
            <span>Subordinate task commission</span>
            <span>{{ number_format($subCommissions, 2) }}</span>
        </div>
        <div class="flex justify-between text-gray-400 text-sm">
            <span>Referral rebate</span>
            <span>{{ number_format($referralRebate, 2) }}</span>
        </div>
    </div>
</div>

</body>
</html>
