<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Withdraw</title>
  </div>
<!-- Hide the GTranslate UI but keep functionality -->
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>

</div>
<div class="gtranslate_wrapper"></div>
<script>
  window.gtranslateSettings = {
    "default_language": "en",
    "detect_browser_language": true,
    "languages": ["en", "ru", "tr", "hi", "es", "de", "bg", "fr", "it", "zh-TW"],
    "wrapper_selector": ".gtranslate_wrapper",
    "horizontal_position": "right",
    "vertical_position": "top"
  };
</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
  <style>
    * { margin:0; padding:0; box-sizing:border-box; font-family: Arial, sans-serif; }
    body {
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: flex-start;
      background: url("<?php echo e(asset('ch/bg.png')); ?>") no-repeat center center/cover;
      padding: 20px;
    }
    .container {
      width: 100%;
      max-width: 450px;
      margin-top: 50px;
      text-align: center;
      position: relative;
    }
    .back-arrow {
      position: absolute;
      top: 15px;
      left: 15px;
      font-size: 24px;
      color: #fff;
      cursor: pointer;
    }
    .section-box {
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      border-radius: 20px;
      padding: 20px;
      margin-top: 20px;
      border: 1px solid rgba(255,255,255,0.3);
    }
    .totalass {
      font-size: 28px;
      font-weight: bold;
      color: #fff;
      margin-bottom: 10px;
    }
    .totalass span {
      font-size: 14px;
      display: block;
      color: #ccc;
    }
    .amount-display {
      background: rgba(255,255,255,0.2);
      border-radius: 20px;
      padding: 15px;
      margin: 15px 0;
      font-size: 22px;
      font-weight: bold;
      color: #fff;
      border: 1px solid rgba(255,255,255,0.3);
      transition: 0.3s;
    }
    .input-box {
      position: relative;
      background: rgba(255,255,255,0.1);
      border-radius: 30px;
      margin: 12px 0;
      display: flex;
      align-items: center;
      padding: 12px 15px;
      border: 1px solid rgba(255,255,255,0.3);
      color: #fff;
    }
    .input-box input, .input-box select {
      border: none;
      outline: none;
      width: 100%;
      font-size: 14px;
      margin-left: 10px;
      background: transparent;
      color: #fff;
    }
    .input-box select option { color: #000; }
    .restbox { display:flex; justify-content:space-between; align-items:center; color:#fff; margin:10px 0; }
    .restbox span { cursor:pointer; color:#1989fa; }
    .btnposit {
      width: 100%;
      padding: 14px;
      border: none;
      border-radius: 30px;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
      margin: 10px 0;
      background: #651054;
      color: #fff;
      transition: 0.3s;
    }
    .btnposit:hover { background: #7a1b6f; }
    .quick-amounts-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(100px, 1fr));
      gap: 10px;
      margin: 15px 0;
    }
    .quick-amounts-grid button {
      padding: 12px;
      border-radius: 20px;
      border: none;
      background: #fff;
      color: #651054;
      font-weight: bold;
      cursor: pointer;
      transition: 0.3s;
    }
    .quick-amounts-grid button:hover {
      background: #7a1b6f;
      color: #fff;
    }
    .tipsui {
      background: rgba(255,255,255,0.1);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      border-radius: 12px;
      padding: 15px;
      margin-top: 20px;
      border: 1px solid rgba(255,255,255,0.3);
      color: #fff;
      font-size: 14px;
      line-height: 1.6;
      text-align: left;
    }
    @media (max-width:480px) {
      .totalass { font-size: 22px; }
      .btnposit { font-size: 14px; padding: 12px; }
      .tipsui { font-size: 13px; }
      .amount-display { font-size: 18px; padding: 12px; }
    }
  </style>
</head>
<body>

<div class="back-arrow" onclick="window.location.href='<?php echo e(route('dashboard')); ?>'">&#8592;</div>

<form action="<?php echo e(route('user.withdraw.request')); ?>" method="post">
  <?php echo csrf_field(); ?>
  <div class="container">
    <div class="section-box">
      <div class="totalass">
        <?php echo e((auth()->user()->balance)); ?>

        <span>Total assets</span>
      </div>

      <!-- Selected Amount Display -->
      <div class="amount-display" id="selected-amount">Select an amount</div>

      <!-- Hidden Input for Form -->
      <input type="hidden" name="amount" id="withdraw-amount" required>

      <!-- Quick Amount Buttons Grid -->
      <div class="quick-amounts-grid">
        <?php
          $quickAmounts = [200, 500, 1000, 3000, 5000, 10000, 15000, 20000, 25000, 50000, 100000, 200000];
        ?>
        <?php $__currentLoopData = $quickAmounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <button type="button" onclick="setAmount(<?php echo e($amt); ?>, this)"><?php echo e($amt); ?></button>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>

      <!-- Login Password -->
      <div class="input-box">
        <input type="password" name="password" placeholder="Enter Fund Password" required>
      </div>

      <div class="restbox">
        <p>Withdraw account</p>
        <span onclick="window.location.href='<?php echo e(route('user.card')); ?>'">Add</span>
      </div>

      <!-- Bank Accounts Dropdown -->
      <div class="input-box">
        <select name="bank_id" required>
          <option value="">-- Select Bank Account --</option>
          <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($bank->id); ?>">
              <?php echo e($bank->bank_name); ?> | <?php echo e($bank->account_number); ?> (<?php echo e($bank->account_name); ?>)
            </option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>

      <button class="btnposit">Withdraw Now</button>

      <div class="tipsui">
        <p>
          Withdraw tips:<br>
          1. Withdrawals processed daily 9 AM - 5 PM.<br>
          2. Minimum withdrawal: 200.<br>
          3. Transfer time: 0-1 hour, up to 24h in exceptional cases.<br>
          4. One withdrawal per day; 10% service fee applies.<br>
          5. Ensure correct withdrawal account info to avoid failure.<br>
          6. Must recharge & purchase a product to activate withdrawal.
        </p>
      </div>
    </div>
  </div>
</form>

<script>
  function setAmount(amount, btn) {
    document.getElementById("withdraw-amount").value = amount;
    document.getElementById("selected-amount").textContent = "" + amount;

    // Remove active style from other buttons
    document.querySelectorAll('.quick-amounts-grid button').forEach(b => {
      b.style.background = '#fff';
      b.style.color = '#651054';
    });

    // Highlight selected button
    btn.style.background = '#7a1b6f';
    btn.style.color = '#fff';
  }
</script>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\Web165\resources\views/app/main/withdraw/index.blade.php ENDPATH**/ ?>