<?php $__env->startSection('admin_content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4>Create New Task</h4>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.tasks.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Title</label>
                            <input type="text" name="title" class="form-control" placeholder="Enter Task Title" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Package</label>
                            <select name="package_id" class="form-control" required>
                                <option value="">Select Package</option>
                                <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($package->id); ?>"><?php echo e($package->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Reward Amount</label>
                            <input type="number" step="0.01" name="reward_amount" class="form-control" placeholder="Enter Reward Amount" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Fake Downloads</label>
                            <input type="number" name="fake_downloads" class="form-control" placeholder="Enter Fake Downloads" required>
                        </div>

                        <div class="form-group col-md-12">
                            <label>Description</label>
                            <textarea name="description" class="form-control" rows="4" placeholder="Enter Task Description"></textarea>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Task Logo</label>
                            <input type="file" name="logo" class="form-control-file">
                        </div>

                        <div class="form-group col-md-6">
                            <label>Status</label>
                            <select name="status" class="form-control">
                                <option value="1" selected>Active</option>
                                <option value="0">Locked</option>
                            </select>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary mt-3">Create Task</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Web165\resources\views/admin/tasks/create.blade.php ENDPATH**/ ?>