<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Customer Service</title>

<style>
body {
  margin: 0;
  min-height: 100vh;
  display: flex;
  justify-content: center;
  align-items: flex-start;   /* push to top */
  padding-top: 15px;        /* small safe spacing */
  background: url("<?php echo e(asset('ch/bg.png')); ?>") no-repeat center/cover;
  font-family: Arial, sans-serif;
}


/* Container */
.container {
  background: rgba(255,255,255,0.12);
  backdrop-filter: blur(16px);
  -webkit-backdrop-filter: blur(16px);
  border-radius: 22px;
  padding: 22px;
  width: 90%;
  max-width: 460px;
  box-shadow: 0 10px 25px rgba(0,0,0,0.25);
  position: relative;
  text-align: center;
}

/* Title */
h2 {
  color: #fff;
  margin-bottom: 16px;
  font-size: 20px;
}

/* Back Arrow */
.back-arrow {
  position: absolute;
  top: 15px;
  left: 15px;
  font-size: 22px;
  color: #fff;
  cursor: pointer;
}

/* Grid */
.grid {
  display: grid;
  grid-template-columns: repeat(2, 1fr);
  gap: 12px;
  margin-bottom: 18px;
}

/* Compact Glass Card */
.card {
  background: rgba(255,255,255,0.18);
  backdrop-filter: blur(18px);
  -webkit-backdrop-filter: blur(18px);
  border-radius: 16px;
  padding: 12px 8px;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  text-decoration: none;
  color: #fff;
  font-size: 12px;
  font-weight: 600;
  border: 1px solid rgba(255,255,255,0.3);
  box-shadow:
    0 6px 14px rgba(0,0,0,0.22),
    inset 0 2px 8px rgba(255,255,255,0.3);
}

/* Large Icons */
.card img {
  width: 50px;
  height: 50px;
  margin-bottom: 6px;
}

/* Brand Tints */
.whatsapp { background: rgba(37,211,102,0.65); }
.telegram { background: rgba(0,136,204,0.65); }
.email    { background: rgba(243,156,18,0.65); }
.phone    { background: rgba(231,76,60,0.65); }
.facebook { background: rgba(59,89,152,0.65); }
.twitter  { background: rgba(29,161,242,0.65); }

/* Info Section */
.info {
  background: rgba(255,255,255,0.1);
  backdrop-filter: blur(14px);
  -webkit-backdrop-filter: blur(14px);
  border-radius: 14px;
  padding: 14px;
  color: #fff;
  font-size: 13px;
  text-align: left;
  line-height: 1.6;
  box-shadow: inset 0 1px 6px rgba(255,255,255,0.25);
}

.info ol {
  margin: 0;
  padding-left: 18px;
}

/* Mobile */
@media (max-width: 480px) {
  .card img {
    width: 46px;
    height: 46px;
  }
  .info {
    font-size: 12px;
  }
}
.inner-action {
  margin-top: 6px;
  padding: 6px 10px;
  font-size: 11px;
  font-weight: 600;
  color: #5a4b00;
  background: rgba(255, 215, 0, 0.55);
  backdrop-filter: blur(10px);
  -webkit-backdrop-filter: blur(10px);
  border-radius: 12px;
  border: 1px solid rgba(255, 215, 0, 0.6);
  box-shadow:
    0 4px 10px rgba(0,0,0,0.2),
    inset 0 1px 6px rgba(255,255,255,0.6);
  display: inline-flex;
  align-items: center;
  gap: 6px;
}

/* Arrow styling */
.arrow {
  font-size: 12px;
  font-weight: 700;
}
.card-img {
    width: 50px;              /* adjust as needed */
    height: 50px;             /* adjust as needed */
    border-radius: 12px;      /* smooth, soft corners */
    object-fit: cover;        /* fills image area without stretching */
    box-shadow: 0 2px 6px rgba(0,0,0,0.2); /* optional subtle shadow for depth */
}

</style>
</head>

<body>
<div class="container">
  <div class="back-arrow" onclick="window.location.href='<?php echo e(route('mine')); ?>'">&#8592;</div>

  <h2>Customer Service</h2>

  <div class="grid">

  <a href="#" class="card whatsapp">
    <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg">
    <span class="title">WhatsApp</span>
    <div class="inner-action">
      Consult Now <span class="arrow">➜</span>
    </div>
  </a>

  <a href="#" class="card whatsapp">
    <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg">
    <span class="title">WhatsApp</span>
    <div class="inner-action">
      Join Now <span class="arrow">➜</span>
    </div>
  </a>

  <a href="#" class="card telegram">
    <img src="https://upload.wikimedia.org/wikipedia/commons/8/82/Telegram_logo.svg">
    <span class="title">Telegram</span>
    <div class="inner-action">
      Consult Now <span class="arrow">➜</span>
    </div>
  </a>

  <a href="#" class="card telegram">
    <img src="https://upload.wikimedia.org/wikipedia/commons/8/82/Telegram_logo.svg">
    <span class="title">Telegram</span>
    <div class="inner-action">
      Join Now <span class="arrow">➜</span>
    </div>
  </a>

  <a href="#" class="card phone">
    <img src="<?php echo e(asset('ch/BBDOLOGO1.jpeg')); ?>" class="card-img">
    <span class="title">Website</span>
    <div class="inner-action">
      Our Website <span class="arrow">➜</span>
    </div>
</a>



  <a href="#" class="card email">
    <img src="https://upload.wikimedia.org/wikipedia/commons/4/4e/Mail_%28iOS%29.svg">
    <span class="title">Email</span>
    <div class="inner-action">
      Consult Now <span class="arrow">➜</span>
    </div>
  </a>

  

  </a>

</div>


  <!-- Info Text -->
  <div class="info">
    <ol>
      <li>It is a service center. You can discuss your external problems with customer service.</li>
      <li>Be sure to wait patiently after you discuss the issues.</li>
      <li>You can contact customer service 24 hours, customer service can solve your account problems.</li>
      <li>Keep an eye on Telegram discussion groups if you want to know more! Discussion time 10:00:00–18:00:00.</li>
    </ol>
  </div>

</div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\Web165\resources\views/app/main/mine/service.blade.php ENDPATH**/ ?>