<?php $__env->startSection('admin_content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="card-title">All Tasks</h4>
                <a href="<?php echo e(route('admin.tasks.create')); ?>" class="btn btn-primary">Add New Task</a>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-striped table-bordered table-hover text-center">
                    <thead class="thead-dark">
                        <tr>
                            <th>ID</th>
                            <th>Title</th>
                            <th>Description</th>
                            <th>Logo</th>
                            <th>Fake Downloads</th>
                            <th>Reward</th>
                            <th>Package</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($task->id); ?></td>
                            <td><?php echo e($task->title); ?></td>
                            <td><?php echo e(Str::limit($task->description, 50)); ?></td>
                            <td>
                                <?php if($task->logo): ?>
                                    <img src="<?php echo e(asset('storage/app/public/uploads/tasks/' . basename($task->logo))); ?>" width="50" alt="logo" class="rounded">
                                <?php else: ?>
                                    <span class="text-muted">No Logo</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($task->fake_downloads); ?></td>
                            <td><?php echo e($task->reward_amount); ?></td>
                            <td><?php echo e($task->package->name ?? 'N/A'); ?></td>
                            <td>
                                <?php if($task->status): ?>
                                    <span class="badge badge-success">Active</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Locked</span>
                                <?php endif; ?>
                            </td>
                            <td class="d-flex justify-content-center gap-1 flex-wrap">
                                <!-- Edit -->
                                <a href="<?php echo e(route('admin.tasks.edit', $task->id)); ?>" class="btn btn-sm btn-info mb-1">Edit</a>
                                
                                <!-- Delete -->
                                <form action="<?php echo e(route('admin.tasks.destroy', $task->id)); ?>" method="POST" class="mb-1" onsubmit="return confirm('Are you sure?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                </form>
                                
                                <!-- Lock/Unlock -->
                                <form action="<?php echo e(route('admin.tasks.toggleStatus', $task->id)); ?>" method="POST" class="mb-1">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm <?php if($task->status): ?> btn-warning <?php else: ?> btn-success <?php endif; ?>">
                                        <?php if($task->status): ?> Lock <?php else: ?> Unlock <?php endif; ?>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center text-muted">No tasks available.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Web165\resources\views/admin/tasks/index.blade.php ENDPATH**/ ?>