<?php $__env->startSection('admin_content'); ?>
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div><?php echo e($title); ?> Withdraw Lists</div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped dataex-html5-selectors">
                                    <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>User Info</th>
                                        <th>Withdraw Info</th>
                                        <th>Amount Details</th>
                                        <th>Withdraw Operation</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>

                                            
                                            <td>
                                                <small>
                                                    Name: <?php echo e($row->user->name ?? '--'); ?>  <br>
                                                    Username: <?php echo e($row->user->username ?? '--'); ?>  <br>
                                                    Ref id: <?php echo e($row->user->ref_id ?? '--'); ?> <br>
                                                    Ref by: <?php echo e($row->user->ref_by ?? '--'); ?> <br>
                                                </small>
                                            </td>

                                            
                                            <td>
                                                <small>
                                          
                                                    Date : <?php echo e($row->created_at); ?> <br><br>

                                                    
                                                    <?php if($row->bank): ?>
                                                        <strong>Bank Name:</strong> <?php echo e($row->bank->bank_name); ?> <br>
                                                        <strong>Account No:</strong> <?php echo e($row->bank->account_number); ?> <br>
                                                        <strong>Account Holder:</strong> <?php echo e($row->bank->account_name); ?> <br>
                                                        <strong>IFSC Code:</strong> <?php echo e($row->bank->ifsc_code ?? '--'); ?> <br>
                                                    <?php else: ?>
                                                        <em>No Bank Info</em>
                                                    <?php endif; ?>
                                                </small>
                                            </td>

                                            
                                            <td>
                                                <small>
                                                    Withdraw Amount: <?php echo e(price($row->amount)); ?> <br>
                                                    Withdraw Charge: <?php echo e(price($row->charge)); ?> <br>
                                                    Return Amount : <?php echo e($row->final_amount); ?> 
                                                </small>
                                            </td>

                                            
                                            <td>
                                                <small>
                                                    Status: <span class="badge 
                                                        <?php if($row->status == 'pending'): ?> badge-warning 
                                                        <?php elseif($row->status == 'approved'): ?> badge-success  
                                                        <?php elseif($row->status == 'rejected'): ?> badge-danger 
                                                        <?php endif; ?>" style="font-size: 8px"><?php echo e($row->status); ?></span> <br>
                                                    Currency: <strong><?php echo e($row->currency); ?></strong>
                                                </small>
                                            </td>

                                            
                                            <td>
                                                <?php if($row->status == 'pending'): ?>
                                                    <a href="javascript:void(0)" data-toggle="modal" data-target="#myModal<?php echo e($row->id); ?>" class="btn btn-success">Action</a>
                                                    <form action="<?php echo e(route('withdraw.status.change', $row->id)); ?>" method="POST"><?php echo csrf_field(); ?>
                                                        <div class="modal fade" id="myModal<?php echo e($row->id); ?>">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">

                                                                    <!-- Modal Header -->
                                                                    <div class="modal-header">
                                                                        <h4 class="modal-title">Action for withdraw</h4>
                                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                    </div>

                                                                    <!-- Modal body -->
                                                                    <div class="modal-body">
                                                                        <div class="form-group">
                                                                            <label for="status">Status <small class="text-info"> Change withdraw status </small> </label>
                                                                            <select name="status" required id="status" class="form-control">
                                                                                <option value="approved" <?php if($row->status == 'approved'): ?> selected <?php endif; ?>>Approved</option>
                                                                                <option value="rejected" <?php if($row->status == 'rejected'): ?> selected <?php endif; ?>>Rejected</option>
                                                                                <option value="pending" <?php if($row->status == 'pending'): ?> selected <?php endif; ?>>Pending</option>
                                                                            </select>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label for="trx">Trx ID </label>
                                                                            <input name="trx" id="trx" class="form-control is-valid" placeholder="Enter send money trx id">
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label for="note">Feedback Note <small class="text-success">(Optional)</small> </label>
                                                                            <textarea name="note" id="note" cols="30"
                                                                                      rows="4" class="form-control is-valid"></textarea>
                                                                        </div>
                                                                    </div>

                                                                    <!-- Modal footer -->
                                                                    <div class="modal-footer">
                                                                        <input type="submit" value="Submit" class="btn btn-primary">
                                                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                <?php else: ?>
                                                    <div class="text-info">Already action taken</div>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Web165\resources\views/admin/pages/withdraw/list.blade.php ENDPATH**/ ?>