<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Wealth Plans</title>
</div>
<!-- Hide the GTranslate UI but keep functionality -->
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>

</div>
<div class="gtranslate_wrapper"></div>
<!-- Hide the GTranslate UI but keep functionality -->
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>

</div>
<div class="gtranslate_wrapper"></div>
<script>
  window.gtranslateSettings = {
    "default_language": "en",
    "detect_browser_language": true,
    "languages": ["en", "sw", "ru", "tr", "hi", "es", "de", "bg", "fr", "it", "zh-TW"],
    "wrapper_selector": ".gtranslate_wrapper",
    "horizontal_position": "right",
    "vertical_position": "top"
  };
</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
<style>
body {
    font-family: Arial, sans-serif;
    background: url("<?php echo e(asset('ch/bg.png')); ?>") no-repeat center center/cover;
    color: #fff;
    padding: 20px;
}
h2 { text-align: center; margin-bottom: 20px; text-shadow: 0 0 10px rgba(255,255,255,0.5); }
.alert { padding: 10px 15px; margin-bottom: 15px; border-radius: 8px; font-weight: bold; }
.success { background: rgba(0,255,0,0.2); color: #0f0; }
.error { background: rgba(255,0,0,0.2); color: #f00; }
.balance { text-align: center; margin-bottom: 25px; font-size: 18px; font-weight: bold; }
.filter-btns { text-align: center; margin-bottom: 20px; }
.filter-btns button {
    padding: 8px 15px;
    margin: 0 5px;
    border: none;
    border-radius: 20px;
    cursor: pointer;
    background: rgba(255,255,255,0.1);
    color: #fff;
    font-weight: bold;
}
.filter-btns button.active { background: #4f46e5; box-shadow: 0 0 10px rgba(79,70,229,0.7); }
.plan-card, .investment-card {
    background: rgba(255,255,255,0.08);
    border: 1px solid rgba(255,255,255,0.2);
    border-radius: 15px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.3);
    backdrop-filter: blur(10px);
}
.plan-card h3, .investment-card p { margin: 5px 0; }
.plan-card form { margin-top: 10px; }
input[type="number"] { padding: 6px 10px; border-radius: 5px; border: none; margin-right: 10px; width: 100px; }
button { padding: 6px 15px; border-radius: 5px; border: none; background: #4f46e5; color: #fff; cursor: pointer; font-weight: bold; transition: 0.3s; }
button:hover { background: #6d28d9; }
.progress-container { background: rgba(255,255,255,0.1); border-radius: 10px; overflow: hidden; height: 15px; margin-top:10px; }
.progress-bar { background: #4f46e5; height: 100%; width: 0%; transition: width 1s; }
.timer { font-weight: bold; margin-top: 5px; }
.min-max { font-style: italic; color: #ccc; margin-bottom: 5px; }
</style>
</head>
<body>
<a href="<?php echo e(route ('mine')); ?>" style="
    display:inline-block;
    margin-bottom:20px;
    padding:8px 16px;
    background: rgba(255,255,255,0.1);
    color:#fff;
    text-decoration:none;
    font-weight:bold;
    border-radius:30px;
    border:1px solid rgba(255,255,255,0.3);
    box-shadow:0 3px 8px rgba(0,0,0,0.3);
    transition:0.3s;
">⬅ Back</a>
<h2>Wealth Plans</h2>

<?php if(session('success')): ?>
<div class="alert success"><?php echo e(session('success')); ?></div>
<?php endif; ?>
<?php if(session('error')): ?>
<div class="alert error"><?php echo e(session('error')); ?></div>
<?php endif; ?>

<div class="balance">Your Balance: <?php echo e($user->balance); ?></div>

<div class="filter-btns">
    <button class="filter-btn active" data-filter="available">Available Plans</button>
    <button class="filter-btn" data-filter="running">Running Plans</button>
</div>

<div id="available-section">
    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="plan-card">
        <?php if($key == 0): ?>
        <img src="<?php echo e(asset('ch/w1.jpeg')); ?>" alt="<?php echo e($plan->name); ?>" style="width:100%; border-radius:12px; margin-bottom:10px;">
        <?php elseif($key == 1): ?>
        <img src="<?php echo e(asset('ch/w2.jpeg')); ?>" alt="<?php echo e($plan->name); ?>" style="width:100%; border-radius:12px; margin-bottom:10px;">
        <?php elseif($key == 2): ?>
        <img src="<?php echo e(asset('ch/w3.jpeg')); ?>" alt="<?php echo e($plan->name); ?>" style="width:100%; border-radius:12px; margin-bottom:10px;">
        <?php endif; ?>

        <h3><?php echo e($plan->name); ?></h3>
        <p class="min-max">Min: <?php echo e($plan->min_amount); ?> | Max: <?php echo e($plan->max_amount); ?></p>
        <p>Duration: <?php echo e($plan->days); ?> days</p>
        <p>Profit: <?php echo e($plan->profit_percent); ?>%</p>
        <form action="<?php echo e(route('user.wealth.invest')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="plan_id" value="<?php echo e($plan->id); ?>">
            <input type="number" name="amount" placeholder="Amount" required min="<?php echo e($plan->min_amount); ?>" max="<?php echo e($plan->max_amount); ?>">
            <button type="submit">Invest</button>
        </form>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>


<div id="running-section" style="display:none;">
    <?php $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="investment-card">
        <p><b>Plan:</b> <?php echo e($inv->plan->name); ?></p>
        <p><b>Amount:</b> <?php echo e($inv->amount); ?></p>
        <p><b>Status:</b> <?php echo e($inv->status == 1 ? 'Active' : 'Completed'); ?></p>
        <p><b>Start:</b> <?php echo e($inv->start_date); ?></p>
        <p><b>End:</b> <?php echo e($inv->end_date); ?></p>
        <div class="progress-container">
            <div class="progress-bar" id="progress-<?php echo e($inv->id); ?>"></div>
        </div>
        <div class="timer" id="timer-<?php echo e($inv->id); ?>">Next earning in: calculating...</div>
        <div class="timer">Daily earning: <?php echo e(number_format($inv->amount * ($inv->plan->profit_percent/100) / $inv->plan->days, 2)); ?></div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<script>
const filterBtns = document.querySelectorAll('.filter-btn');
const availableSection = document.getElementById('available-section');
const runningSection = document.getElementById('running-section');

filterBtns.forEach(btn => {
    btn.addEventListener('click', () => {
        filterBtns.forEach(b => b.classList.remove('active'));
        btn.classList.add('active');

        const filter = btn.getAttribute('data-filter');
        if(filter=='available'){ availableSection.style.display='block'; runningSection.style.display='none'; }
        else { availableSection.style.display='none'; runningSection.style.display='block'; }
    });
});

<?php $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
(function(){
    const start = new Date("<?php echo e($inv->start_date); ?> 00:00:00").getTime();
    const end = new Date("<?php echo e($inv->end_date); ?> 23:59:59").getTime();
    const progressBar = document.getElementById('progress-<?php echo e($inv->id); ?>');
    const timerEl = document.getElementById('timer-<?php echo e($inv->id); ?>');

    function updateProgress() {
        const now = new Date().getTime();
        const total = end - start;
        const elapsed = now - start;
        let percent = Math.min((elapsed/total)*100, 100);
        progressBar.style.width = percent + '%';
    }

    function updateTimer() {
        const now = new Date();
        let nextMidnight = new Date();
        nextMidnight.setHours(24,0,0,0);
        let diff = nextMidnight - now;
        let hours = Math.floor(diff/1000/60/60);
        let minutes = Math.floor((diff/1000/60)%60);
        let seconds = Math.floor((diff/1000)%60);
        timerEl.innerHTML = "Next earning in: "+hours+"h "+minutes+"m "+seconds+"s";
    }

    updateProgress();
    updateTimer();
    setInterval(() => { updateProgress(); updateTimer(); }, 1000);
})();
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\Web165\resources\views/user/wealth/index.blade.php ENDPATH**/ ?>