<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Recharge</title>
  </div>
<!-- Hide the GTranslate UI but keep functionality -->
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>

</div>
<div class="gtranslate_wrapper"></div>
<script>
  window.gtranslateSettings = {
    "default_language": "en",
    "detect_browser_language": true,
    "languages": ["en", "ru", "tr", "hi", "es", "de", "bg", "fr", "it", "zh-TW"],
    "wrapper_selector": ".gtranslate_wrapper",
    "horizontal_position": "right",
    "vertical_position": "top"
  };
</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: url("<?php echo e(asset ('ch/bg.png')); ?>") no-repeat center center/cover; }
    .header { background: #4804c6ff; color:#fff; padding:15px; font-size:18px; display:flex; align-items:center; }
    .back-btn { color:#fff; text-decoration:none; margin-right:10px; font-size:20px; }
    .back-btn:hover { color:#ffcdd2; }
    .method-card { background:#fff; padding:15px; margin:10px 0; border-radius:10px; box-shadow:0 2px 6px rgba(0,0,0,0.1); transition:0.3s; }
    .method-card:hover { background:#f3e9ff; cursor:pointer; }
    .method-title { font-weight:600; font-size:16px; }
    .method-desc { font-size:13px; color:#666; }
    .badge-type { font-size:11px; text-transform:uppercase; padding:3px 6px; border-radius:5px; }
    .badge-usdt { background:#28a745; color:#fff; }
    .badge-wallet { background:#007bff; color:#fff; }
  </style>
</head>
<body>

  <div class="header">
    <a href="<?php echo e(route('dashboard')); ?>" class="back-btn">&larr;</a>
    Recharge
  </div>

  <div class="container mt-3">
    <p class="text-muted">
        Available balance <?php echo e(number_format(Auth::user()->balance ?? 0,2)); ?>, please choose a recharge method:
    </p>

    <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php
        // Dynamic link based on type
        $link = $method->type === 'usdt' 
                  ? route('recharge.usdt', $method->id) 
                  : route('recharge.amount', $method->id);
      ?>

      <a href="<?php echo e($link); ?>" class="text-decoration-none text-dark">
        <div class="method-card d-flex align-items-center justify-content-between">
          <div class="d-flex align-items-center">
            <?php if($method->photo): ?>
              <img src="<?php echo e(asset($method->photo)); ?>" width="40" class="me-3 rounded">
            <?php endif; ?>
            <div>
              <div class="method-title"><?php echo e($method->channel); ?></div>
              <div class="method-desc">
                Min: <?php echo e(number_format($method->minimum,2)); ?> | Max: <?php echo e(number_format($method->maximum,2)); ?>

              </div>
            </div>
          </div>
          <div>
            <span class="badge-type <?php echo e($method->type === 'usdt' ? 'badge-usdt' : 'badge-wallet'); ?>">
              <?php echo e($method->type); ?>

            </span>
          </div>
        </div>
      </a>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

  </div>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\Web165\resources\views/app/main/deposit/index.blade.php ENDPATH**/ ?>