<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Help & Support</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: Arial, sans-serif;
    }

    body {
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: flex-start;
      background: url("<?php echo e(asset ('ch/bg.png')); ?>") no-repeat center center/cover;
      padding: 20px;
    }

    .container {
      width: 100%;
      max-width: 600px;
      position: relative;
    }

    .header {
      text-align: center;
      margin-bottom: 20px;
    }

    .header h1 {
      font-size: 26px;
      font-weight: bold;
      color: #fff;
    }

    /* Glass effect box (reuse style) */
    .info-box {
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      padding: 20px;
      border-radius: 12px;
      margin-bottom: 15px;
      border: 1px solid rgba(255, 255, 255, 0.3);
    }

    .info-box h3 {
      color: #fff;
      font-size: 18px;
      margin-bottom: 10px;
    }

    .info-box p {
      color: #f1f1f1;
      font-size: 14px;
      line-height: 1.6;
      margin: 0;
    }

    .btn {
      width: 100%;
      padding: 14px;
      border: none;
      border-radius: 30px;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
      margin: 10px 0;
      transition: 0.3s ease;
    }

    .btn-back {
      background: #651054;
      color: #fff;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }

    .btn-back:hover {
      background: #7a1b6f;
    }

    /* Mobile responsive */
    @media (max-width: 480px) {
      .header h1 {
        font-size: 22px;
      }
      .info-box h3 {
        font-size: 16px;
      }
      .info-box p {
        font-size: 13px;
      }
    }
  </style>
</head>
<body>

  <div class="container">
    <div class="header">
      <h1>Help & Support</h1>
    </div>

    <div class="info-box">
      <h3>📱 How to Register?</h3>
      <p>Click on the "Register Now" button from the login page, fill in your phone number and password, and complete your registration.</p>
    </div>

    <div class="info-box">
      <h3>🔑 Forgot Password?</h3>
      <p>Contact our support team through the app or official Telegram channel to reset your password securely.</p>
    </div>

    <div class="info-box">
      <h3>💰 How to Earn?</h3>
      <p>Earn money by completing tasks, participating in daily draws, and inviting friends to join the platform.</p>
    </div>

    <div class="info-box">
      <h3>📞 Contact Support</h3>
      <p>If you face any issues, reach out to us via our 24/7 support team at <b>support@bbdoncom.com</b>.</p>
    </div>

    <button class="btn btn-back" onclick="window.location.href='<?php echo e(route('dashboard')); ?>'">⬅ Back to Home</button>
  </div>
</div>
<!-- Hide the GTranslate UI but keep functionality -->
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>

</div>
<div class="gtranslate_wrapper"></div>
<script>
  window.gtranslateSettings = {
    "default_language": "en",
    "detect_browser_language": true,
    "languages": ["en", "ru", "tr", "hi", "es", "de", "bg", "fr", "it", "zh-TW"],
    "wrapper_selector": ".gtranslate_wrapper",
    "horizontal_position": "right",
    "vertical_position": "top"
  };
</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
</body>
</html>

<!-- Hide the GTranslate UI but keep functionality -->
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>

</div>
<div class="gtranslate_wrapper"></div>
<script>
  window.gtranslateSettings = {
    "default_language": "en",
    "detect_browser_language": true,
    "languages": ["en", "ru", "tr", "hi", "es", "de", "bg", "fr", "it", "zh-TW"],
    "wrapper_selector": ".gtranslate_wrapper",
    "horizontal_position": "right",
    "vertical_position": "top"
  };
</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
<?php /**PATH C:\xampp\htdocs\Web165\resources\views/app/main/help.blade.php ENDPATH**/ ?>